/**
 *  MemoryInfoSet.h
 *
 *  Copyright(c) Live2D Inc. All rights reserved.
 *  [[ CONFIDENTIAL ]]
 */

#pragma once


#ifndef __SKIP_DOC__

#include "../../Live2D.h"

#ifndef NULL
#  define NULL    0
#endif


//--------- LIVE2D NAMESPACE ------------
namespace live2d 
{

	class AMemoryHolder ;
	class MemoryParam ;
	class MemoryInfo ;


	//******************************************************
	class MemoryInfoSet // fobOpȂ̂ŊǗO
	{
		friend class UtMemory ;
		friend class MemoryInfo ;
	public:
		MemoryInfoSet(const char* setName);
		~MemoryInfoSet(void);

		void dump(const char* message = NULL ) ;
		void dumpList( MemoryInfo *info ) ;

		void addMemoryInfo( void* ptr , MemoryParam* owner , l2d_size_t size , const char* filename , int lineno ) ;
		void removeMemoryInfo( void* ptr ) ;

		int getMallocTotal(){ return mallocTotal ; }	// malloc̉񐔂JEg
		int	getRestCount(){ return restCount ; }		// mۂĂ|C^JEg (malloc++ , free--)
		int	getTotalMemory(){ return totalMemory ; }	// ݐσ

		int getCurMemory(){ return curMemory ; }		// ݂̃
		int getPeakMemory(){ return peakMemory ; }		// ő厞̃

	private:
		const char*		setName ;

		int				mallocTotal ;			// malloc̉񐔂JEg
		int				restCount ;				// mۂĂ|C^JEg (malloc++ , free--)
		int				totalMemory ;			// ݐσ
		int				curMemory ;				// ݂̃
		int				peakMemory ;			// ő厞̃

		MemoryInfo*		usingMemoryInfo ;		// gp̐擪iAXgj
		MemoryInfo*		lastUsingMemoryInfo ;	// gp񃊃Xg̍ŌiAXgj
		MemoryInfo*		freeMemoryInfo ;		// ς݃񃊃XgiAXgj
		MemoryInfo*		lastFreeMemoryInfo ;	// ς݃񃊃Xg̍ŌiAXgj
	};
}
//--------- LIVE2D NAMESPACE ------------

#endif // __SKIP_DOC__
