/**
 *  EyeBlinkMotion.h
 *
 *  Copyright(c) Live2D Inc. All rights reserved.
 *  [[ CONFIDENTIAL ]]
 */
#ifndef __LIVE2D_EYE_BLINK_MOTION_H__
#define __LIVE2D_EYE_BLINK_MOTION_H__


#include "../memory/LDObject.h"

#include "../type/LDVector.h"

#include "../ALive2DModel.h"


//--------- LIVE2D NAMESPACE ------------
namespace live2d 
{

	
	class EyeBlinkMotion : public live2d::LDObject 
	{

	public:
		// ̏Ԓ萔
		enum EYE_STATE{
			STATE_FIRST = 0 , 
			STATE_INTERVAL ,
			STATE_CLOSING ,// Ăr
			STATE_CLOSED , // Ă
			STATE_OPENING ,// JĂr
		};

	public:
		// Constructor
		EyeBlinkMotion();

		// Destructor
		virtual ~EyeBlinkMotion();

	public:
		//  ̂܂΂[V̎ݒ
		long long calcNextBlink() ;

		//  C^[oԂ̐ݒ
		void setInterval( int blinkIntervalMsec) ;

		//  ܂΂[V̐ݒ
		void setEyeMotion( int closingMotionMsec , int closedMotionMsec , int openingMotionMsec ) ;

		//  w肵f̃p[^ݒ
		void setParam( live2d::ALive2DModel *model ) ;

	private:
		long long 			nextBlinkTime ;				// p`鎞imsecj
		
		int 				eyeState ;					// ݂̏
		long long 			stateStartTime ;			// ݂stateJn

		bool 				closeIfZero;				// IDŎw肳ꂽ̃p[^A0̂ƂɕȂ true A1̎ɕȂ false
		
		live2d::LDString 	eyeID_L ;					// ڂID
		live2d::LDString 	eyeID_R ;					// EڂID

		int					blinkIntervalMsec ;			// 
		int 				closingMotionMsec ;			// Ⴊ܂ł̎
		int 				closedMotionMsec  ;			// ܂܂ł鎞
		int 				openingMotionMsec ;			// ႪJ܂ł̎

	};

}
//--------- LIVE2D NAMESPACE ------------


#endif		// __LIVE2D_EYE_BLINK_MOTION_H__