/**
 *  Live2DMotionBin.h
 *
 *  Copyright(c) Live2D Inc. All rights reserved.
 *  [[ CONFIDENTIAL ]]
 */

#pragma once


#include "../Live2D.h"
#include "../ALive2DModel.h"
#include "../type/LDVector.h"
#include <vector>
#include "AMotion.h"


//--------- LIVE2D NAMESPACE ------------
namespace live2d
{
	class MotionBin ;
	class MotionQueueEnt ;



	
	class Live2DMotionBin : public AMotion{
	public:

		// loadMotionŃoCinꍇɁARǂ̂悤ɂ邩w肷
		typedef enum {
			// fXgNgɌf[^jȂ
			DO_NOTHING_ON_DESTRUCT ,		// OŔj
			DUPLICATE_AND_DESTRUCT ,		// nf[^𕡐Ďginf[^ɂ͉Ȃj

			// fXgNgɎw̕Ŕj
			FREE_ON_DESTRUCT ,				// free()Ŕj
			DELETE_ARRAY_ON_DESTRUCT , 		// delete[]Ŕj
			DELETE_NORMAL_ON_DESTRUCT  , 	// ʏdelete Ŕj
			
			L2D_FREE_ON_DESTRUCT ,			// Live2DƎ̃ǗŔj
			UTFILE_RELEASE_ON_DESTRUCT		// UtFile::releaseLoadBuffer()Ŕj
		} BufType ;



		Live2DMotionBin();
		virtual ~Live2DMotionBin();
		
		virtual void updateParamExe( live2d::ALive2DModel * model , long long timeMSec , float weight , MotionQueueEnt *motionQueueEnt) ;


		void setLoop( bool _loop ){ this->loop = _loop ; }
		bool isLoop( ){ return this->loop ; }
		
		/**
		 * [V̒Ԃi[v̂Ƃ -1j
		 * -1̂Ƃ͏IȂƂȂ
		 */
		virtual int getDurationMSec() ;
		
		
		/** 
		 * mtnt@CŒ`Ã[V̒i[vP񕪂̒jԂ (0.9.00b8)
		 */
		virtual int getLoopDurationMSec(){ 
			return loopDurationMSec ; // mtnt@CŒ`Ã[V̒
		}

		/*
		 * [Vf[^[h
		 * 
		 * QoCg͖Ή
		 */
		static Live2DMotionBin * loadMotion( const l2d_string & filepath ) ;

		/*
		 * [Vf[^oCg񂩂烍[h
		 *
		 * bufType  buf̃|C^ǂ̂悤ɔj邩|C^mۂ̕ɂ킹Ĉȉw肷B
		 *
		 *   BufType::DO_NOTHING_ON_DESTRUCT ,		// fXgNgɔjȂiOŔjj
		 *	 BufType::DUPLICATE_AND_DESTRUCT ,		// nf[^𕡐Ďginf[^ɂ͉Ȃj
		 *	 BufType::FREE_ON_DESTRUCT ,			// fXgNgfree()Ŕj
		 *	 BufType::DELETE_ARRAY_ON_DESTRUCT , 	// fXgNgdelete[]Ŕj
		 *	 BufType::DELETE_NORMAL_ON_DESTRUCT  , // fXgNgɒʏdelete Ŕj
		 *	 BufType::UTFILE_RELEASE_ON_DESTRUCT	// fXgNgUtFile::releaseLoadBuffer()Ŕj
		 *
		 * deleteBufOnDestructor bufLive2DMotionBinDestructorŔjꍇtrue
		 */
		static Live2DMotionBin * loadMotion( 
						const void * buf ,					// [Vt@C[h|C^
						int bufSize ,						// [Ṽf[^TCY(oCgj
						Live2DMotionBin::BufType  bufType	// buf̎gAj̎dw肷
					) ;
		


		void dump() ;
		


	private:
		const void *				buf ;// [hꂽoCiBdeleteBufOnDestructortruȅꍇɔj

		Live2DMotionBin::BufType	bufType ;// bufǂ̂悤Ɉienum BufType Ŏw肷j
	//	bool						deleteBufOnDestructor ;// DestructorŃ|C^jꍇtrue

		//---- 
		MotionBin**					motionPtrArray ;
		int							paramCount ;//count of MotionBin

		// ---- [hf[^
		float 						srcFps ;// [ht@CFPSBLq΃ftHgl15fpsƂȂ
		int 						maxLength ;

		int 						loopDurationMSec ;// mtnt@CŒ`Ã[V̒
		bool 						loop ;
		int 						objectNoForDebug ;
		
		float 						lastWeight ;
		live2d::MemoryParam*		memoryManagement ;
		live2d::AMemoryHolder*		memoryHolderFixedMain ;

	};




#ifndef __SKIP_DOC__

	//=================================================
	//  	̃p[^ɂẴANV`NX
	//=================================================
	class MotionBin : public live2d::LDObject
	{
	public:
		static const int MOTION_TYPE_PARAM = 0 ;
		static const int MOTION_TYPE_PARTS_VISIBLE = 1 ;
		
		// ύXsi < ŔrĂ邽 j
		static const int MOTION_TYPE_LAYOUT_X = 100 ;
		static const int MOTION_TYPE_LAYOUT_Y = 101 ;
		static const int MOTION_TYPE_LAYOUT_ANCHOR_X = 102 ;
		static const int MOTION_TYPE_LAYOUT_ANCHOR_Y = 103 ;
		static const int MOTION_TYPE_LAYOUT_SCALE_X = 104 ;
		static const int MOTION_TYPE_LAYOUT_SCALE_Y = 105 ;
		
		MotionBin(void);
		virtual ~MotionBin(void);
		
		int getParamIndex( live2d::ALive2DModel* model ) ;

	public:
		//--- fields ---
		l2d_string * 			paramIDStr ;

		// ̃fŃ[Vg܂킷Index̃LbVłȂ
		live2d::ParamID* 		cached_paramID ;
		int  					cached_paramIndex ;//
		live2d::ALive2DModel* 	cached_model_ofParamIndex ;

	//	l2d_vector<float> 		values ;

		// f[^̎Afloat[] short[]^̓ގg
		// ʏ̓f[^TCY邽 min,maxԂshort(65536iK16bit)ɕ
		// l̃WLꍇi min,max = -1000,1000̂悤ȏꍇj
		// 萸x̍float[](23bit)pĒڒlݒ肷

		// min,max̊Ԃshortlݒ肷ꍇ true
		bool					isShortArray ;

		void*					valuePtr ;// float[]܂short[]wBt@C̃oCi𒼐ڎQƂ̂ŔjȂ
		float					minValue ;
		float					maxValue ;
		
		int						valueCount ;
		
		int 					motionType ;
	};

#endif // __SKIP_DOC__

}
//--------- LIVE2D NAMESPACE ------------