/**
 *  MotionQueueManager.h
 *
 *  Copyright(c) Live2D Inc. All rights reserved.
 *  [[ CONFIDENTIAL ]]
 */
#ifndef __LIVE2D_MOTION_QUEUE_MANAGER_H__
#define __LIVE2D_MOTION_QUEUE_MANAGER_H__


#include "../memory/LDObject.h"
#include "../ALive2DModel.h"

#include "../type/LDVector.h"
#include "AMotion.h"

//--------- LIVE2D NAMESPACE ------------
namespace live2d
{
	class Live2DMotion ;
	class MotionQueueEnt ;
	class MemoryParam ;


	
	class MotionQueueManager : public live2d::LDObject 
	{
	public:
		MotionQueueManager();
		virtual ~MotionQueueManager();
		
		// w̃[VJn
		// ^Cṽ[Vɂꍇ́Ã[VɏItO𗧂āAtF[hAEgJnB
		int startMotion( AMotion * motion , bool autoDelete ) ;
		
		// f̃p[^ݒAXVi𔽉fj
		bool updateParam( live2d::ALive2DModel * model ) ;

		//  SẴ[VIĂ邩
		bool isFinished() ;
		
		// Ŏw肵[VIĂ邩ԂB(0.8.09ǉj
		bool isFinished(int motionQueueEntNo ) ;


		//  SẴ[V~
		void stopAllMotions() ;

		//  [V̊JnEI_v
		void setMotionDebugMode( bool f ){ this->motionDebugMode = f ; }

		//  MotionQueueEnt擾
		MotionQueueEnt* getMotionQueueEnt( int entNo ) ;
	    
	#if L2D_VERBOSE
		void DUMP() ;
	#endif

	private:
		live2d::LDVector<MotionQueueEnt *> *motions ;

		bool motionDebugMode ;// [V̍ĐE~_vtO

		live2d::MemoryParam*  memoryManagement ;
		live2d::AMemoryHolder*	memoryHolderFixedMain ;
	};

}
//--------- LIVE2D NAMESPACE ------------

#endif		// __LIVE2D_MOTION_QUEUE_MANAGER_H__