/**
 *
 *  You can modify and use this source freely
 *  only for the development of application related Live2D.
 *
 *  (c) Live2D Inc. All rights reserved.
 */

#include "FileManager.h"
#include "MyLive2DAllocator.h"
#include <stdio.h>
#include "type/LDString.h"


unsigned char* FileManager::loadFile(const char* filepath,int* ret_bufsize)
{
		FILE *fp; //  (1)t@C|C^̐錾
		unsigned char * buf;
	
		//  (2)t@C̃I[vBŁAt@C|C^擾
		if ( fopen_s( &fp , filepath, "rb") ) //return nonzero if error
		{
			L2D_DEBUG_MESSAGE("file open error %s!!" , filepath );
			return NULL;
		}
	
		// ------------ TCY̔ ------------
		fseek(fp, 0, SEEK_END );
		int size = ftell(fp);// TCY擾
	
		buf = (unsigned char*)malloc( size );// ̊mہiOŊJj
		L2D_ASSERT_S( buf != 0 , "malloc( %d ) is NULL @ fileload %s" , size , filepath ) ;
		
	
		fseek(fp, 0, SEEK_SET);
	
		//  ǂݍ
		int loaded = (int)fread(buf, sizeof(char), size, fp);
		fclose(fp); //  (5)t@C̃N[Y
	
		// ------------ ǂݍ߂ ------------
		if (loaded != size)
		{
			L2D_DEBUG_MESSAGE("file load error / loaded size is wrong / %d != %d\n" , loaded , size );
	
	
			return NULL;
		}
	
		*ret_bufsize = size ;
		return buf;

}


void FileManager::releaseBuffer(void* ptr)
{
	free(ptr);
}


/***********************************************************
	eNX`ǂݍ
************************************************************/
void FileManager::loadTexture( LPDIRECT3DDEVICE9 g_pD3DDevice, const char * textureFilePath, LPDIRECT3DTEXTURE9* tex)
{
	if( FAILED( D3DXCreateTextureFromFileExA( g_pD3DDevice
				, textureFilePath 
				, 0	//width 
				, 0	//height
				, 0	// mipmap( 0Ȃ犮Sȃ~bv}bv`F[j
				, 0	//Usage
				, D3DFMT_A8R8G8B8                
				, D3DPOOL_MANAGED
				, D3DX_FILTER_LINEAR
				, D3DX_FILTER_BOX
				, 0			  
				, NULL
				, NULL
				, tex ) ) )
	{
		L2D_DEBUG_MESSAGE("Could not create texture \n" , textureFilePath );
		return ;
	}
}


/***********************************************************
	efBNg̎擾
************************************************************/
void FileManager::getParentDir( const char* path , std::string* return_dir ){
	(*return_dir) = path ;
	(*return_dir) += "\\..\\" ;

}
