﻿using System.Collections.Generic;
using Microsoft.Xna.Framework.Content.Pipeline.Processors;
using Microsoft.Xna.Framework.Content;
using MikuMikuDance.XNA.Model.ModelData;

namespace MikuMikuDance.XNA.Model
{
    /// <summary>
    /// TypeWrite前のMMDModelクラス
    /// </summary>
    [ContentSerializerRuntimeType("MikuMikuDance.XNA.Model.ModelData.MMDModelData, MikuMikuDanceXNA")]
    public class MMDModelContext
    {
        /// <summary>
        /// XNA用モデルデータ
        /// </summary>
        public ModelContent ModelData { get; set; }
        /// <summary>
        /// MMD用のボーン情報
        /// </summary>
        public List<MMDBoneData> Bones { get; set; }
        /// <summary>
        /// MMD用の表情情報
        /// </summary>
        public List<MMDSkinData> Skins { get; set; }
        /// <summary>
        /// 表情で用いる頂点数
        /// </summary>
        public int NumVertexForFace { get; set; }
        /// <summary>
        /// MMD用の剛体情報
        /// </summary>
        public List<MMDRigid> Rigids { get; set; }
        /// <summary>
        /// MMD用のジョイント情報
        /// </summary>
        public List<MMDJoint> Joints { get; set; }
        
    }
}
