using System;
using System.Collections.Generic;
using System.Linq;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Audio;
using Microsoft.Xna.Framework.Content;
using Microsoft.Xna.Framework.GamerServices;
using Microsoft.Xna.Framework.Graphics;
using Microsoft.Xna.Framework.Input;
using Microsoft.Xna.Framework.Media;
using Microsoft.Xna.Framework.Net;
using Microsoft.Xna.Framework.Storage;
using MikuMikuDance.XNA.Model;
using MikuMikuDance.XNA;
using MikuMikuDance.XNA.Motion;

namespace MikuMikuDanceXNADemo
{
    /// <summary>
    /// MikuMikuDance for XNÃf
    /// </summary>
    public class Game1 : Microsoft.Xna.Framework.Game
    {
        GraphicsDeviceManager graphics;
        //MikuMikuDance for XNA
        MikuMikuDanceXNA mmd;
        //MMDff[^
        MMDModel model;
        //MMD[Vf[^
        MMDMotion motion;
        
        public Game1()
        {
            graphics = new GraphicsDeviceManager(this);
            Content.RootDirectory = "Content";
            mmd = new MikuMikuDanceXNA(this);
        }

        protected override void Initialize()
        {
            base.Initialize();
        }

        /// <summary>
        /// LoadContent
        /// </summary>
        protected override void LoadContent()
        {
            //f̃[hil̎ɂAfƃ[Vt@C͓Ă܂BKvȕMMD)
            model = mmd.LoadModel("Miku", this, Matrix.Identity);
            //[Ṽ[h
            motion = mmd.LoadMotion("TrueMyHeart");
            model.Player.SetMotion(motion, true);
        }

        /// <summary>
        /// UnloadContent
        /// </summary>
        protected override void UnloadContent()
        {
        }

        bool EnterFlag = true;
        /// <summary>
        /// Abvf[g
        /// </summary>
        /// <param name="gameTime">Provides a snapshot of timing values.</param>
        protected override void Update(GameTime gameTime)
        {
            if (GamePad.GetState(PlayerIndex.One).Buttons.Back == ButtonState.Pressed)
                this.Exit();
            if (Keyboard.GetState().IsKeyDown(Keys.Escape))
                this.Exit();
            if (Keyboard.GetState().IsKeyDown(Keys.Enter) || GamePad.GetState(PlayerIndex.One).Buttons.A == ButtonState.Pressed)
            {
                if (EnterFlag)
                {
                    //_X̍Đ
                    model.Player.Start(0, gameTime, false);
                    EnterFlag = false;
                }
            }
            else
            {
                if (!EnterFlag)
                    EnterFlag = true;
            }

            
            base.Update(gameTime);
        }

        /// <summary>
        /// This is called when the game should draw itself.
        /// </summary>
        /// <param name="gameTime">Provides a snapshot of timing values.</param>
        protected override void Draw(GameTime gameTime)
        {
            GraphicsDevice.Clear(Color.CornflowerBlue);

            
            base.Draw(gameTime);
        }
    }
}
