#pragma once
#include "BulletPhysics.h"
#include "SkinMesh.h"

class MmdPhysics {
private:
	LPDIRECT3DDEVICE9 pDevice;
	vector<Bone>* bones;					// S{[zւ̃|C^
	BulletPhysics* bulletPhysics;
	vector<btRigidBody*> rigidBodies;		// 1bVɑ΂鍄̔z
	vector<int> rigidbody_relatedBoneIndex;	// êɊ֘A{[̃CfbNX
	vector<int> rigidbody_type;				// ễ^Cv
	vector<D3DXMATRIX> rigidbody_init;		// ê̏ps
	vector<D3DXMATRIX> rigidbody_offset;	// ễItZbgs
	vector<ID3DXMesh*> rigidbody_mesh;		// ễbV
	ID3DXMesh* joint_mesh;					// WCg̃bV
	vector<int> joint_relatedRigidIndex;	// eWCg̊֘A
	vector<D3DXMATRIX> joint_matrix;		// eWCg̎ps(A[JWn)

public:
	MmdPhysics(LPDIRECT3DDEVICE9 pDevice, BulletPhysics* bulletPhysics);
	~MmdPhysics();

	/// S{[zւ̃|C^Zbg
	/// @param bones S{[zւ̃|C^
	void SetBones(vector<Bone>* bones);

	/// ̂쐬
	/// @param pmdRigidBodies Pmd̔z
	/// @param pmdBones Pmd{[z
	void CreateRigid(vector<MmdStruct::PmdRigidBody> pmdRigidBodies, vector<MmdStruct::PmdBone> pmdBones);

	/// WCg쐬
	/// @param pmdBones PmdWCgz
	void CreateJoint(vector<MmdStruct::PmdJoint> pmdJoints);

	/// {[sXV
	/// @param Zgp\
	void BoneUpdate(bool physicsEnabled);

	/// ̃bV`悷
	void DrawRigidMesh(D3DXMATRIX* world, D3DLIGHT9* light, Camera* camera);

	/// WCgbV`悷
	void DrawJointMesh(D3DXMATRIX* world, D3DLIGHT9* light, Camera* camera);


	// ⏕֐
private:
	D3DXMATRIX CreateRigidMatrix(float* pos, float* rot, int i);
	void StartWireframe(D3DXMATRIX* world, D3DLIGHT9* light, Camera* camera, D3DCOLORVALUE color);
	void EndWireframe();

};
