#pragma once
#include "Camera.h"
#include "VmdMotionController.h"
#include "PmdFileLoader.h"
#include "tstring.h"

/// XLbV
class SkinMesh {
protected:
	/// { ///
	SkinMesh(LPDIRECT3DDEVICE9 pDevice);// IuWFNg֎~
	LPDIRECT3DDEVICE9 pDevice;			// Direct3DfoCXIuWFNg
	/// bV ///
	LPD3DXMESH pMesh;					// bV
	vector<D3DMATERIAL9> materials;		// }eAz
	vector<LPDIRECT3DTEXTURE9> textures;// eNX`z
	vector<D3DXBONECOMBINATION> boneCombination;// {[Rrl[Vz
	virtual LPD3DXSKININFO CreateSkinInfo(const vector<BlendVertex>, const unsigned int, const D3DVERTEXELEMENT9*);	// bV̂߂̃XL쐬
	virtual void DivideMesh(unsigned int numFace, LPD3DXMESH pOrgMesh, LPD3DXSKININFO pSkinInfo);					// uhspbg̃TCYzȂ悤ɃbV𕪊
	/// {[ ///
	vector<Bone> bones;					// {[\
	ID3DXMesh* boneMesh;				// {[pbV
	virtual void CreateBoneMesh();		// {[pbV쐬
	virtual vector<D3DXMATRIX> GetWorlds(const D3DXMATRIX* world);					// {[s񂩂ϊ[hϊs̔z擾
	/// VF[_ ///
	D3DXHANDLE hTech, hWorld, hView, hProj, hAmbient, hDiffuse, hLightDir, hTexture;// nh
	LPD3DXEFFECT pFX;		// VF[_
	void CreateShader();	// VF[_̍쐬
public:
	virtual ~SkinMesh();
	virtual void Draw(D3DXMATRIX* world, D3DLIGHT9* light, Camera* camera);				// `
	virtual void DrawBoneMeshes(D3DXMATRIX* world, D3DLIGHT9* light, Camera* camera);	// {[\
};

/// MMDXLbV
/// ӁFPMD`̏{[͉]ȂIȂ킿ApsA{[ItZbgs͏ɉ]ȂB
class MmdSkinMesh sealed : public SkinMesh {
private:
	vector<MmdStruct::PmdIkData> pmdIkData;

public:
	MmdSkinMesh(
		LPDIRECT3DDEVICE9 pDevice, 
		vector<MmdStruct::PmdVertex> pmdVertices, 
		vector<unsigned short> pmdFaces, 
		vector<MmdStruct::PmdMaterial> pmdMaterials, 
		vector<MmdStruct::PmdBone> pmdBones, 
		vector<MmdStruct::PmdIkData> pmdIkData,
		tstring directoryName
		);

	// VmdMotionControllerւ̃Np
	vector<Bone>*					GetBonesAsPointer()		{ return &bones; }
	vector<MmdStruct::PmdIkData>*	GetPmdIkDataAsPointer()	{ return &pmdIkData; }



	// ⏕p֐
private:
	void LoadPmdfile(const LPCTSTR&, vector<MmdStruct::PmdVertex>&, vector<unsigned short>&, vector<MmdStruct::PmdMaterial>&, vector<MmdStruct::PmdBone>&);
	void CreateMesh(vector<MmdStruct::PmdVertex>, vector<unsigned short>, vector<MmdStruct::PmdMaterial>, const unsigned int numBone, tstring directoryName);
	void CreateBoneMatrix(vector<MmdStruct::PmdBone> pmdBones);
	void CopyMaterial(D3DMATERIAL9&, const MmdStruct::PmdMaterial&);
	vector<unsigned long> CreateMaterial(unsigned int numFace, vector<MmdStruct::PmdMaterial> pmdMaterials, tstring directoryName);
	vector<BlendVertex> CreateVertices(LPD3DXMESH pOrgMesh, vector<MmdStruct::PmdVertex> pmdVertices);
	void CreatePolygon(LPD3DXMESH pOrgMesh, vector<unsigned short> pmdFaces);
	void CreateAttribute(LPD3DXMESH pOrgMesh, vector<unsigned long> material_numbers);
	tstring GetTextureFilename(const char* texture_file_name, tstring directoryName);
};

