#pragma once

/// bV̒_f[^
struct Vertex {
	D3DXVECTOR3 position;	// _ʒu
	D3DXVECTOR3 normal;		// @xNg
	D3DXVECTOR2 texture;	// eNX`W
};

/// bṼ|Sf[^
struct Face {
	unsigned short indices[3];		// 3_̃CfbNX
	unsigned long material_number;	// ޗԍ
};

// bVf[^ꎞۑp\́BƎ`f[^͈x̍\̂Ɋi[AMesh::SetMesh()Mesh::pMeshɃZbgB
struct MeshData {
	vector<Vertex> vertices;
	vector<Face> faces;
	vector<D3DMATERIAL9> material;
	vector<string> texture_filename;
};

/// bṼx[X
class Mesh {
protected:
	LPDIRECT3DDEVICE9 pDevice;			// Direct3DfoCXIuWFNg
	LPD3DXMESH pMesh;					// bV
	D3DMATERIAL9* pMeshMaterials;		// }eAz
	LPDIRECT3DTEXTURE9*	pMeshTextures;	// eNX`z
	DWORD dwNumMaterials;				// }eAEeNX`z̑傫
	void AddNormalVector(MeshData& meshData);// MeshDataɖ@xNgǉ
	void SetMesh(MeshData meshData);	// MeshDatapMeshɃZbg
public:
	Mesh(LPDIRECT3DDEVICE9 pDevice);
	virtual ~Mesh();
	virtual void Draw(D3DXVECTOR3 position, D3DXMATRIX rotation);
	virtual LPD3DXMESH GetMesh();
	virtual int GetNumMaterial();
};

/// bṼr[ϊAˉeϊsȂJ
class MeshCamera sealed {
private:
	LPDIRECT3DDEVICE9 pDevice;
public:
	MeshCamera(LPDIRECT3DDEVICE9 pDev);
	void Look(D3DXVECTOR3 eyePoint, D3DXVECTOR3 lookAtPoint);
};

/// bVpCg
class MeshLight sealed {
private:
	LPDIRECT3DDEVICE9 pDevice;
	D3DLIGHT9 light;
public:
	MeshLight(LPDIRECT3DDEVICE9 pDev);
	void Illume(D3DXVECTOR3 direction);
};

/// Xt@CǍ񂾃bV
class XFileMesh sealed : public Mesh {
public:
	XFileMesh(LPCTSTR filename, LPDIRECT3DDEVICE9 pDevice);
};

/// ^ZRCAt@CǍ񂾃bV
class MqoMesh sealed : public Mesh {
private:
	template <typename T> vector<T> MaterialPickOut(string str, char* name, int n); // }eAs̕񂩂w肵O̒l̔z擾
	void LoadMaterial(ifstream& ifs, MeshData& meshData);
	void LoadObject(ifstream& ifs, MeshData& meshData);
	MeshData GetMeshDataFromMQO(LPCTSTR filename); // ^ZRCAt@C烁bVf[^Ǎ
public:
	MqoMesh(LPCTSTR filename, LPDIRECT3DDEVICE9 pDevice);
};

/// PMDt@CǍ񂾃bV
class PmdMesh sealed : public Mesh {
/// PMD\̒`
#pragma pack(push,1)	//ACgIt
	struct PmdHeader {
		unsigned char magic[3];
		float version;
		unsigned char model_name[20];
		unsigned char comment[256];
	} pmdHeader;
	struct PmdVertex{
		float pos[3];
		float normal_vec[3];
		float uv[2];
		unsigned short bone_num[2];
		unsigned char bone_weight;
		unsigned char edge_flag;
	};
	struct PmdMaterial{
		float diffuse_color[3];
		float alpha;
		float specularity;
		float specular_color[3];
		float mirror_color[3];
		unsigned char toon_index;
		unsigned char edge_flag;
		unsigned long face_vert_count;	// ̍ޗ̖ʒ_  ޗԍĩ|SԍF pmdMaterial[i - 1].face_vert_count/3 ` pmdMaterial[i].face_vert_count/3 - 1
		char texture_file_name[20];
	};
#pragma pack(pop)
	void CopyMaterial(D3DMATERIAL9& material, PmdMaterial& pmdMaterial);	// PmdMaterialD3DMATERIAL9Ƀf[^Rs[
public:
	PmdMesh(LPCTSTR filename, LPDIRECT3DDEVICE9 pDevice);
};