#include "StdAfx.h"
#include "MyApplication.h"
#include "CollisionDetection.h"

MyApplication::MyApplication(HWND hWnd) {
	directXFramework = new DirectXFramework(hWnd);
	LPDIRECT3DDEVICE9 pDevice = directXFramework->GetD3DDevice();
	island = new XFileMesh(TEXT("batokin_island5.x"), pDevice);
	//yukkuri = new XFileMesh(TEXT("yukkuri4.x"), pDevice);
	//yukkuri = new MqoMesh(TEXT("yukkuri4.mqo"), pDevice);
	//yukkuri = new PmdMesh(TEXT("reimu.pmd"), pDevice);
	yukkuri = new MqoMesh(TEXT("marisa.mqo"), pDevice);
	shadow = new Shadow(pDevice, yukkuri->GetMesh(), yukkuri->GetNumMaterial());
	shadowVolume = new ShadowVolume(pDevice, yukkuri->GetMesh());
	meshLight = new MeshLight(pDevice);
	meshCamera = new MeshCamera(pDevice);
}

MyApplication::~MyApplication(void) {
	delete meshCamera;
	delete meshLight;
	delete shadow;
	delete shadowVolume;
	delete yukkuri;
	delete island;
	delete directXFramework;
}

void MyApplication::Run() {
	directXFramework->BeginScene(0x0F, 0xFF , 0xFF);// V[Jn
	static int t;
	const D3DXVECTOR3 position(0, 0, 0), zeroVector(0, 0, 0);
	D3DXMATRIX rotation, unitMatrix;
	D3DXMatrixRotationY(&rotation, 0.01f*(++t));
//	D3DXMatrixRotationY(&rotation, D3DX_PI*0.85f);
	D3DXMatrixIdentity(&unitMatrix);

	// Cg
	D3DXVECTOR3 direction(-1, -1, -1);	// ̕
	meshLight->Illume(direction);		// Ă

	// J
	D3DXVECTOR3 eyePoint = D3DXVECTOR3(-0.2f, 0.3f, 1.5f);	// _
	D3DXVECTOR3 lookAtPoint = D3DXVECTOR3(0, 0.4f, 0);		// _
	//D3DXVECTOR3 eyePoint = D3DXVECTOR3(-0.2f, 1.5f, 1.0f);	// _
	//D3DXVECTOR3 lookAtPoint = D3DXVECTOR3(0, 1.7f, 0);		// _
	meshCamera->Look(eyePoint, lookAtPoint);				// 

	// `
	island->Draw(zeroVector, unitMatrix);
	yukkuri->Draw(position, rotation);
	shadow->Draw(position, rotation, direction, D3DXPLANE(0, -1, 0, 0));
	//shadowVolume->Draw(position, rotation, direction);

	directXFramework->EndScene();			// V[I
}