#pragma once
#include "Mesh.h"
#include "XFileAnimationMesh.h"

// ʓe@ɂe
class Shadow : public Drawable3D {
protected:
	LPDIRECT3DDEVICE9	pDevice;
	LPD3DXMESH			pMesh;
	int					NumMaterial;		// bṼ}eA
	D3DMATERIAL9		shadow_material;	// ẽ}eA
	D3DXPLANE			plane;				// e̗镽
	void StencileEnable();					// XeVobt@Lɂ
	void StencileDisable();					// XeVobt@𖳌ɂ

public:
	// @param pDevice		D3DfoCX
	// @param pMesh			bV
	// @param NumMaterial	bV̍ޗ
	Shadow(LPDIRECT3DDEVICE9 pDevice, LPD3DXMESH pMesh, int NumMaterial);

	// @param plane		e̗镽
	virtual void SetPlane(D3DXPLANE* plane);

	virtual void Draw(D3DXVECTOR3* position, D3DXMATRIX* rotation, D3DLIGHT9* light, Camera* camera);
};


// }eAƃeNX`ZbgȂept[`p֐Q
class FrameRenderingForShadow sealed : public FrameRendering {
private:
	void RenderMeshContainer(LPDIRECT3DDEVICE9, MYMESHCONTAINER* ,MYFRAME*) override;
};


// XFileAj[Vp ʓe@ɂe 
class XFileAnimationShadow sealed : public Shadow {
	FrameRenderingForShadow frameRenderingForShadow;
	LPD3DXFRAME pFrame;
public:
	// @param pDevice	D3DfoCX
	// @param pFrame	t[
	XFileAnimationShadow(LPDIRECT3DDEVICE9 pDevice, LPD3DXFRAME pFrame);

	void Draw(D3DXVECTOR3* position, D3DXMATRIX* rotation, D3DLIGHT9* light, Camera* camera);
};


// VhE{[NX
class ShadowVolume sealed : public Drawable3D {
private:
	LPDIRECT3DDEVICE9	pDevice;
	LPD3DXMESH			pMesh;
	unsigned long		numVertex;			// VhE{[̒_̐
	D3DXVECTOR3			vertex[1000000];		// VhE{[̒_̈ʒuf[^
	void CreateVolume(D3DXVECTOR3 direction);
	void RenderVolume(D3DXMATRIX world);
	void RenderVolumeToStencil(D3DXMATRIX world);
	void RenderShadowBoard();
	D3DXMATRIX GetWorldMatrix(D3DXVECTOR3* position, D3DXMATRIX* rotation);
	D3DXVECTOR3 GetLocalDirection(D3DXMATRIX* rotation, D3DXVECTOR3* direction);
public:
	ShadowVolume(LPDIRECT3DDEVICE9 pDevice, LPD3DXMESH pMesh);
	void Draw(D3DXVECTOR3* position, D3DXMATRIX* rotation, D3DLIGHT9* light, Camera* camera);
	void DrawVolume(D3DXVECTOR3* position, D3DXMATRIX* rotation, D3DLIGHT9* light);
};
