#pragma once

// BulletCu̓}l[WIvVŃRpCłȂI
#pragma unmanaged
#include "btBulletDynamicsCommon.h"
#pragma managed

#ifdef _DEBUG
#pragma comment(lib,"../BulletLib/BulletCollision_vs2010_debug.lib")
#pragma comment(lib,"../BulletLib/BulletDynamics_vs2010_debug.lib")
#pragma comment(lib,"../BulletLib/BulletSoftBody_vs2010_debug.lib")
#pragma comment(lib,"../BulletLib/LinearMath_vs2010_debug.lib")
#else
#pragma comment(lib,"../BulletLib/BulletCollision_vs2010.lib")
#pragma comment(lib,"../BulletLib/BulletDynamics_vs2010.lib")
#pragma comment(lib,"../BulletLib/BulletSoftBody_vs2010.lib")
#pragma comment(lib,"../BulletLib/LinearMath_vs2010.lib")
#endif

/// ZBullet̃bp[NX
class BulletPhysics sealed {
private:
	btDefaultCollisionConfiguration* collisionConfiguration;
	btCollisionDispatcher* dispatcher;
	btBroadphaseInterface* overlappingPairCache;
	btSequentialImpulseConstraintSolver* solver;
	btDiscreteDynamicsWorld* dynamicsWorld;
	btAlignedObjectArray<btCollisionShape*> collisionShapes;
	btRigidBody* CreateShape(btCollisionShape* shape, const D3DXMATRIX* world,
							float mass, float restitution, float friction, float linear_damp, float angular_damp, bool kinematic, unsigned short group, unsigned short mask);
	btVector3 ConvertVectorDxToBt(const D3DXVECTOR3&);
	D3DXVECTOR3 ConvertVectorBtToDx(const btVector3&);
	btTransform ConvertMatrixDxToBt(const D3DXMATRIX&);
	D3DXMATRIX ConvertMatrixBtToDx(const btTransform&);
public:
	BulletPhysics(const D3DXVECTOR3& gravity);
	~BulletPhysics();	
	
	/// ̃IuWFNg
	/// 0, kinematicfalseɂƁAȂstatiĉɂȂB
	/// 0, kinematictrueɂƁA蓮œ邪AZ̉e󂯂ȂKinematiĉɂȂ
	btRigidBody* CreateBox(float width, float height, float depth, const D3DXMATRIX* world, 
		float mass = 0, float restitution = 0, float friction = 0.5f, float linear_damp = 0, float angular_damp = 0, bool kinematic = 0, unsigned short group = 1, unsigned short mask = 0xFFFF);
	btRigidBody* CreateSphere(float radius, const D3DXMATRIX* world, 
		float mass = 0, float restitution = 0, float friction = 0.5f, float linear_damp = 0, float angular_damp = 0, bool kinematic = 0, unsigned short group = 1, unsigned short mask = 0xFFFF);
	btRigidBody* CreateCylinder(float radius, float length, const D3DXMATRIX* world,	// SZ
		float mass = 0, float restitution = 0, float friction = 0.5f, float linear_damp = 0, float angular_damp = 0, bool kinematic = 0, unsigned short group = 1, unsigned short mask = 0xFFFF);
	btRigidBody* CreateCapsule(float radius, float height, const D3DXMATRIX* world,	// SZ. height͋̒SԂ̋
		float mass = 0, float restitution = 0, float friction = 0.5f, float linear_damp = 0, float angular_damp = 0, bool kinematic = 0, unsigned short group = 1, unsigned short mask = 0xFFFF);

	// Sǉ
	void AddPointToPointConstraint(btRigidBody* body, const D3DXVECTOR3& pivot);
	void AddPointToPointConstraint(btRigidBody* bodyA, btRigidBody* bodyB, const D3DXVECTOR3& pivotInA, const D3DXVECTOR3& pivotInB);

	/// 6WCgǉ
	/// @param bodyA A
	/// @param bodyB B
	/// @param frameInA WCg̃[hϊs(A[JWn)
	/// @param frameInB WCg̃[hϊs(B[JWn)
	/// @param c_p1 ړ1
	/// @param c_p2 ړ2
	/// @param c_r1 ]1
	/// @param c_r2 ]2
	/// @param stiffness ol(sړx, y, z, ]ړx, y, z̏6vf)
	void Add6DofSpringConstraint(btRigidBody* bodyA, btRigidBody* bodyB, const D3DXMATRIX& frameInA, const D3DXMATRIX& frameInB,
								const D3DXVECTOR3& c_p1, const D3DXVECTOR3& c_p2, const D3DXVECTOR3& c_r1, const D3DXVECTOR3& c_r2, vector<float> stiffness);

	// ̂ړ
	void MoveRigidBody(btRigidBody* body, const D3DXMATRIX* world);
	
	// Z̐E̎Ԃ1/60bi߂
	void StepSimulation();
	
	// ʂ̃[hs擾
	D3DXMATRIX GetWorld(btRigidBody* body);
};
