#include "stdafx.h"
#include "DirectXFramework.h"

DirectXFramework::DirectXFramework(HWND hWnd){
	if (!hWnd) throw TEXT("Direct3D̍쐬Ɏs܂\nEBhEnh܂");		// EBhEnhmF
	if (!(pD3d = Direct3DCreate9( D3D_SDK_VERSION))) throw TEXT("Direct3D̍쐬Ɏs܂");	// Direct3DIuWFNg̍쐬
	D3DCAPS9 Caps;
	pD3d->GetDeviceCaps(D3DADAPTER_DEFAULT, D3DDEVTYPE_HAL, &Caps);	// _uXeṼT|[gmF
	if (!(Caps.StencilCaps & D3DSTENCILCAPS_TWOSIDED)) MessageBoxW(0,TEXT("_uXeVɑΉĂ܂"),TEXT(""),MB_OK);

	// test
	//int s0 = Caps.MaxVertexBlendMatrixIndex;	// = 0  ̃O{͒_uhsCfbNXT|[gĂȂII
	//int s1 = Caps.MaxVertexBlendMatrices;	// = 4  ̃O{1|S4uhs񐔈ȏT|[gĂȂII
	//										// _uhsCfbNXgȂĂő3_~4uh = 12uhs̉\̂ŒӁI

	CreateDirect3DDeviceObject(hWnd);	// DIRECT3DfoCXIuWFNg̍쐬
	SetRenderingConfiguration();	// _O{ݒ
	SetFogConfiguration();			// tHO̐ݒ
}

void DirectXFramework::CreateDirect3DDeviceObject(HWND hWnd){
	D3DPRESENT_PARAMETERS d3dpp; 
	ZeroMemory( &d3dpp, sizeof(d3dpp) );   // Öق D3DPRESENT_INTERVAL_DEFAULT = 0 ݒ聨j^̃tbV[g = FPS
	d3dpp.BackBufferFormat =D3DFMT_UNKNOWN;
	d3dpp.BackBufferCount=1;
	d3dpp.SwapEffect = D3DSWAPEFFECT_DISCARD;	
	d3dpp.Windowed = TRUE;
    d3dpp.EnableAutoDepthStencil = TRUE;
	d3dpp.AutoDepthStencilFormat = D3DFMT_D24S8;		//Zobt@24rbgAXeVobt@8rbg Ȃ̂OK
	d3dpp.Flags = D3DPRESENTFLAG_DISCARD_DEPTHSTENCIL;	//_uXeV
	if (FAILED(pD3d->CreateDevice(D3DADAPTER_DEFAULT, D3DDEVTYPE_HAL, hWnd, D3DCREATE_HARDWARE_VERTEXPROCESSING, &d3dpp, &pDevice))){
		if (FAILED(pD3d->CreateDevice(D3DADAPTER_DEFAULT, D3DDEVTYPE_HAL, hWnd, D3DCREATE_SOFTWARE_VERTEXPROCESSING, &d3dpp, &pDevice))){
			MessageBox(0,TEXT("HAL[hDIRECT3DfoCX쐬ł܂\nREF[hōĎs܂"),NULL,MB_OK);
			if (FAILED(pD3d->CreateDevice(D3DADAPTER_DEFAULT, D3DDEVTYPE_REF, hWnd, D3DCREATE_HARDWARE_VERTEXPROCESSING, &d3dpp, &pDevice))){
				if (FAILED(pD3d->CreateDevice(D3DADAPTER_DEFAULT, D3DDEVTYPE_REF, hWnd, D3DCREATE_SOFTWARE_VERTEXPROCESSING, &d3dpp, &pDevice))){
					throw TEXT("DIRECT3DfoCX̍쐬Ɏs܂");
				}
			}
		}
	} 
}

void DirectXFramework::SetRenderingConfiguration(){
	pDevice->SetRenderState( D3DRS_ZENABLE, TRUE);					// Zobt@[Lɂ
	//pDevice->SetRenderState(D3DRS_CULLMODE, D3DCULL_CCW);			// JO
	pDevice->SetRenderState(D3DRS_CULLMODE, D3DCULL_NONE);
	pDevice->SetRenderState(D3DRS_LIGHTING, TRUE);					// CgLɂ
	pDevice->SetRenderState(D3DRS_AMBIENT, 0);						// ArGgCgijݒ肷
	pDevice->SetRenderState(D3DRS_SPECULARENABLE,TRUE);				// XyLiʔˁjLɂ
	pDevice->SetRenderState(D3DRS_ALPHABLENDENABLE, TRUE);			// At@ufBOL
	pDevice->SetRenderState(D3DRS_SRCBLEND, D3DBLEND_SRCALPHA);
	pDevice->SetRenderState(D3DRS_DESTBLEND, D3DBLEND_INVSRCALPHA);
}

void DirectXFramework::SetFogConfiguration(){
	const FLOAT fogStart = 300;
	const FLOAT fogEnd = 2000;
	D3DCAPS9 caps;
	ZeroMemory(&caps,sizeof(D3DCAPS9));
	pDevice->GetDeviceCaps(&caps);	
	if ((caps.RasterCaps & D3DPRASTERCAPS_FOGTABLE) == 0)
		if(MessageBox(0, TEXT("sNZtHOgȂ\܂Bs܂?"), TEXT(""), MB_ABORTRETRYIGNORE) == IDABORT) throw TEXT("tHOݒɎs܂");
	pDevice->SetRenderState(D3DRS_FOGENABLE, TRUE);	
	pDevice->SetRenderState(D3DRS_FOGCOLOR, D3DCOLOR_ARGB(150,255,255,255)); 		
	pDevice->SetRenderState(D3DRS_FOGVERTEXMODE, D3DFOG_NONE );	
	pDevice->SetRenderState(D3DRS_FOGTABLEMODE, D3DFOG_LINEAR );		 
	pDevice->SetRenderState(D3DRS_FOGSTART, *(DWORD *)(&fogStart));		
	pDevice->SetRenderState(D3DRS_FOGEND, *(DWORD *)(&fogEnd));
}

DirectXFramework::~DirectXFramework(void) {
	SAFE_RELEASE(pDevice);
	SAFE_RELEASE(pD3d);
}

LPDIRECT3DDEVICE9 DirectXFramework::GetD3DDevice() {
	return pDevice;
}

void DirectXFramework::BeginScene(int r, int g, int b) {
	pDevice->Clear( 0, NULL, D3DCLEAR_TARGET | D3DCLEAR_ZBUFFER | D3DCLEAR_STENCIL, D3DCOLOR_XRGB(r, g, b), 1.0f, 0 );
	if (!SUCCEEDED(pDevice->BeginScene())) throw TEXT("BeginSceneɎs܂");
}

void DirectXFramework::EndScene() {
	pDevice->EndScene();
	pDevice->Present(NULL, NULL, NULL, NULL);
}

