#pragma once
#include "Camera.h"
#include "DirectXFramework.h"
#include "SkinMesh.h"
#include "Coord.h"
#include "ControlVariable.h"
#include "BulletPhysics.h"
#include "MmdPhysics.h"

class MyApplication sealed {
private:
	DirectXFramework* directXFramework;
	MmdSkinMesh* mmdSkinMesh;
	VmdMotionController* vmdMotionController;
	Coord* coord;
	float aspect;
	ControlVariable* controlVariable;
	LPDIRECT3DDEVICE9 pDevice;
	BulletPhysics* bulletPhysics;
	MmdPhysics* mmdPhysics;

public:
	// RXgN^
	// @param hWnd EBhEnh
	MyApplication(HWND hWnd, ControlVariable* controlVariable);

	// fXgN^
	~MyApplication();

	// t[sȂ鏈
	void Run();


	// ⏕֐
private:
	float GetAspect(HWND hWnd);
	void OpenPmdFile(tstring filename);
	void OpenVmdFile(tstring filename);
};
