﻿/*
"Copyright (first published1 date)2 (most recent published date)3 Intel Corporation.

The source code, information and material ("Material") contained herein is owned by Intel Corporation or its 
suppliers or licensors, and title to such Material remains with Intel Corporation or its suppliers or licensors. 
The Material contains proprietary information of Intel or its suppliers and licensors. The Material is 
protected by worldwide copyright laws and treaty provisions. No part of the Material may be used, copied, 
reproduced, modified, published, uploaded, posted, transmitted, distributed or disclosed in any way without Intel's 
prior express written permission. No license under any patent, copyright or other intellectual property rights in 
the Material is granted to or conferred upon you, either expressly, by implication, inducement, estoppel or otherwise. 
Any license under such intellectual property rights must be express and approved by Intel in writing.

Include any supplier copyright notices as supplier requires Intel to use.

Include supplier trademarks or logos as supplier requires Intel to use, preceded by an asterisk. An asterisked footnote 
can be added as follows: *Third Party trademarks are the property of their respective owners.

Unless otherwise agreed by Intel in writing, you may not remove or alter this notice or any other notice 
embedded in Materials by Intel or Intel's suppliers or licensors in any way."

*/

using System;
using System.Threading;
using System.Windows.Forms;

namespace RSVoiceSample
{
    public partial class MainForm : Form
    {

        RSVoice _rsVoice;
        Thread _voiceThread;


        // delegates are needed due to threading.
        // Sets the label to either running or stopped
        delegate void SetStatusLabelDelegate( string str );

        // Used to add a new word to the list of words
        delegate void AddWordToListDelegate( string word );


        /// <summary>R
        /// Form construction
        /// </summary>
        public MainForm( )
        {
            InitializeComponent( );
            _rsVoice = new RSVoice( );
            _rsVoice.OnWordDetected += AddWordToListEventHandler;
            _rsVoice.OnStopProcessing += StoppedRecording;
        }


        /// <summary>
        /// Button event handler
        /// </summary>
        private void btnStart_Click( object sender, EventArgs e )
        {
            _voiceThread = new System.Threading.Thread( StartVoiceRecognition );
            _voiceThread.Start( );
        }


        /// <summary>
        /// Instructs the RSVoice object to stop recording speech and looking for matching words
        /// </summary>
        private void btnStop_Click( object sender, EventArgs e )
        {
            _rsVoice.StopSpeechRecognition( );
        }



        private void StoppedRecording( object source, EventArgs e )
        {
            _rsVoice.Dispose( );
            _rsVoice = null;
            _voiceThread = null;
            SetLabel( "Stopped" );

        }



        /// <summary>
        /// Event handler when the RSVoice object has detected a word and dispatched an event.
        /// </summary>
        /// <param name="source">Who sent it</param>
        /// <param name="e">The event object that contains the detected word</param>
        private void AddWordToListEventHandler( object source, WordEventArg e )
        {
            // Because AddWordToListEvenHandler is an event hander, it's cleaner to just call
            // another function to deal with the multithreading code
            AddWordToList( e.GetDetectedWord( ) );
        }



        /// <summary>
        /// Adds a word to the listbox
        /// </summary>
        /// <param name="s">The string to add to the list box</param>
        /// <remarks>Adds the word in a thread safe manor</remarks>
        private void AddWordToList( string s )
        {
            if( lstWords.InvokeRequired )
            {
                AddWordToListDelegate addWordDelegate = new AddWordToListDelegate( AddWordToList );
                this.Invoke( addWordDelegate, new object[ ] { s } );
            }
            else
            {
                lstWords.Items.Add( s );
            }
        }



        /// <summary>
        /// The function that tells the RSVoice object to start processing speech.
        /// </summary>
        private void StartVoiceRecognition( )
        {
            if( _rsVoice.Initialized )
            {
                SetLabel( "Running" );
                _rsVoice.StartSpeechRecognition( );
            }
            //SetLabel( "Stopped" );
        }


        /// <summary>
        /// Because we are running in multi threads we have to ensure thread safety.
        /// </summary>
        /// <param name="s">The text we want the lable to display.</param>
        /// <remarks>Adds the word in a thread safe manor</remarks>
        private void SetLabel( string s )
        {
            if( lblStatus.InvokeRequired )
            {
                SetStatusLabelDelegate statusDelegate = new SetStatusLabelDelegate( SetLabel );
                this.Invoke( statusDelegate, new object[ ] { s } );
            }
            else
            {
                lblStatus.Text = s;
            }
        }


        /// <summary>
        /// Triggered when the form is shutting down.
        /// </summary>
        private void FormIsClosing( object sender, FormClosingEventArgs e )
        {
            if( _rsVoice != null && _rsVoice.Initialized )
            {
                _rsVoice.StopSpeechRecognition( );
            }
        }
    }
}
