// Copyright (C) 2010 Kosei Demura
// This file is part of the irrDrawStuff library.
// Please read copyright notice in irrdrawstuff.h for conditions of distribution and usage. 

#include "drawMesh.h"

namespace {
	SimLoop *sim = SimLoop::getInstance();
}

DrawMesh::DrawMesh(ISceneManager *smgr)
{
	ismgr = smgr;
}

DrawMesh::~DrawMesh()
{
}

void DrawMesh::setDriver(IVideoDriver *driver)
{
	idriver = driver;
}

void DrawMesh::loadMesh(char *file_name,char *texture_name, float **vertices_address,int *vertexcount,
                dTriIndex **indices_address,	int *indexcount, float *pos,float *scale)
{
    // 3Dmodel scale
    float s0 = *scale;
    float s1 = *scale;
    float s2 = *scale;

    // load mesh
    myMesh[0] = ismgr->getMesh((const c8*) file_name);

    if (!myMesh[0])
    {
        cout << "diLoadMesh: No mesh \n";
        exit(0);
    }

    myMeshNode[0] = ismgr->addAnimatedMeshSceneNode(myMesh[0]);

    if (myMeshNode[0])
    {
        myMeshNode[0]->setMaterialFlag(EMF_LIGHTING, false);   // モデルにライトを反映させるか
        //　影を入れると描画速度が遅くなる
        // meshNode[0]->addShadowVolumeSceneNode();    // 影の設定
        // smgr->setShadowColor(video::SColor(150,0,0,0)); // 影の色
        if (texture_name)
        {
            myMeshNode[0]->setMaterialTexture(0, idriver->getTexture((const c8*) texture_name));// テクスチャの設定
        }
        myMeshNode[0]->setScale(vector3df(s0,s1,s2)); // モデルのスケール
        myMeshNode[0]->setPosition(vector3df(-pos[1],pos[2],pos[0])); // モデルの位置
    }

    if (myMesh[0]==NULL || myMeshNode[0]==NULL) 
			return; // do nothing if the mesh or node is NULL
    int ci,cif,cv;
    unsigned int i,j;
    *indexcount  = 0;
    *vertexcount = 0;

    for (i=0; i < myMesh[0]->getMeshBufferCount();i++)
    {
        irr::scene::IMeshBuffer* mb = myMesh[0]->getMeshBuffer(i);
        *indexcount  += mb->getIndexCount();
        *vertexcount += mb->getVertexCount();
    }

	float *vertices1;
	dTriIndex *indices1;

    vertices1 =  new float[(*vertexcount)*3];
    indices1  =  new dTriIndex[(*indexcount)*3];

    // fill trimesh geom
    ci  = 0;
    cif = 0; // for many buffers
    cv  = 0;

    // Returns the amount of mesh buffers (IMeshBuffer) in this mesh
    for (i=0; i< myMesh[0]->getMeshBufferCount(); i++)
    {
        irr::scene::IMeshBuffer* mb = myMesh[0]->getMeshBuffer(i);

        irr::u16* mb_indices=mb->getIndices();
        // fill indices
        for (j=0;j<mb->getIndexCount();j++)
        {
            indices1[j] = (dTriIndex) cif + mb_indices[j];
        }
        cif += mb->getVertexCount();

        if (mb->getVertexType()==irr::video::EVT_STANDARD)
        {
            irr::video::S3DVertex* mb_vertices=(irr::video::S3DVertex*)mb->getVertices();
            // fill vertices
            for (j=0;j<mb->getVertexCount();j++)
            {
                vertices1[3*cv+0] = float(mb_vertices[j].Pos.Z * s0 * (-1.0));
                vertices1[3*cv+1] = float(mb_vertices[j].Pos.X * s1);
                vertices1[3*cv+2] = float(mb_vertices[j].Pos.Y * s2);
                cv++;
            }
        }
        else if (mb->getVertexType()==irr::video::EVT_2TCOORDS)
        {
            irr::video::S3DVertex2TCoords* mb_vertices=(irr::video::S3DVertex2TCoords*)mb->getVertices();
            for (j=0;j<mb->getVertexCount();j++)
            {
                vertices1[3*cv+0] = mb_vertices[j].Pos.X;
                vertices1[3*cv+1] = mb_vertices[j].Pos.Y;
                vertices1[3*cv+2] = mb_vertices[j].Pos.Z;
                cv++;
            }
        }
    }

    *vertices_address = (float *) vertices1;
    *indices_address  = (dTriIndex *) indices1;

	safe_delete_array(vertices1); // add demu
	safe_delete_array(indices1);  // add demu

    vector3df pos1 = myMeshNode[0]->getPosition();
}




// ODE側で指定された3Dモデルの読み込みと設定. 3Dモデルの情報をODE用に変換してODE側に渡す
// Load a 3D model file
extern "C" void diLoadMesh(char *file_name,char *texture_name, float **vertices_address,int *vertexcount,
                dTriIndex **indices_address,	int *indexcount, float *pos,float *scale)
{
    sim->mesh->loadMesh(file_name, texture_name, vertices_address, vertexcount, 
					indices_address, indexcount, pos, scale);
}

void DrawMesh::drawMeshBuffer(const dReal* pos, const dReal* R,  
		float *vertices, int vertex_count, 
		unsigned int *indices, int index_count, int solid)
{
	SMeshBuffer *mb = new SMeshBuffer; // meshBufferCount;
    mb->append(vertices, vertex_count,(u16 *const) indices, index_count);
	idriver->drawMeshBuffer(mb);
	mb->drop();

	SMesh *smesh = new SMesh;
	smesh->MeshBuffers.push_back(mb);
    smesh->recalculateBoundingBox();
	idriver->drawMeshBuffer(smesh->getMeshBuffer(smesh->getMeshBufferCount()-1));
}


extern "C" void diDrawMesh(const dReal* pos, const dReal* R,  
		float *vertices, int vertex_count, unsigned int *indices, int index_count, int wire_frame)		
{
	sim->mesh->drawMeshBuffer(pos, R, vertices, vertex_count, indices, index_count, wire_frame);
}
