// Copyright (C) 2010 Kosei Demura
// This file is part of the irrDrawStuff library.
// Please read copyright notice in irrdrawstuff.h for conditions of distribution and usage. 
// メッシュ描画に関するクラス．drawstuffにはない部分．今後の充実する予定

#ifndef __IDS_DRAW_MESH_H
#define __IDS_DRAW_MESH_H

#include "simLoop.h"

extern "C" void diLoadMesh(char *file_name,char *texture_name, float **vertices_address,int *vertexcount,
                dTriIndex **indices_address,	int *indexcount, float *pos,float *scale);

class DrawMesh
{
public:
	DrawMesh(irr::scene::ISceneManager *smgr);
	~DrawMesh();
	void loadMesh(char *file_name,char *texture_name, float **vertices_address,int *vertexcount,
                dTriIndex **indices_address, int *indexcount, float *pos,float *scale);
	void setDriver(IVideoDriver *driver);
	void drawMeshBuffer(const dReal* pos, const dReal* R, float *vertices, int vertex_count, 
		unsigned int *indices, int index_count, int solid);
private:
	static const int objectNum = 100;
	irr::scene::ISceneManager *ismgr;
	irr::video::IVideoDriver *idriver;
	irr::scene::IAnimatedMesh *myMesh[objectNum];
	irr::scene::IAnimatedMeshSceneNode *myMeshNode[objectNum];
};

#endif

