// Copyright (C) 2010 Kosei Demura
// This file is part of the irrDrawStuff library.
// Please read copyright notice in irrdrawstuff.h for conditions of distribution and usage. 

#include "vision.h"
#include "eventReceiver.h"
#include "misc.h"

using namespace irr::gui;

namespace {
	SimLoop *sim = SimLoop::getInstance();
}

static int CURRENT_KEY = 0;

// Constructor
idsEventReceiver::idsEventReceiver() //:mx(0),my(0),mode(0)
{
	pause = 0;
	singleStep = 0;  // true: single step
	fn2 = 0;
	//mx = 0;
	//my = 0;
	//mode = 0;
}

idsEventReceiver::~idsEventReceiver()
{
}

void idsEventReceiver::init(IrrlichtDevice *device, diFunctions *fn, int init_pause)
{
	idevice = device;
	fn2 = fn;
	pause = init_pause;
}


void idsEventReceiver::setPause(int a)
{
	pause = a;
}

int idsEventReceiver::getPause()
{
	return pause;
}



void idsEventReceiver::setSingleStep(int a)
{
	singleStep = a;
}

int idsEventReceiver::getSingleStep()
{
	return singleStep;
}

void idsEventReceiver::showInfo(char *str, float info[3]) 
{
	printf("%s %.1f, %.1f, %.1f\n",str, info[0],info[1],info[2]);
}

bool idsEventReceiver::OnEvent(const SEvent& event)
{       
	if (event.EventType == EET_KEY_INPUT_EVENT)
	{
		if (event.KeyInput.PressedDown)
		{
			CURRENT_KEY = event.KeyInput.Key;

			if (event.KeyInput.Control)
			{
				// コントロールキーが押されている時; When Control Key is pressed
				switch (CURRENT_KEY)
				{
				case 'o': case 'O':
					if (pause) singleStep = 1;
					return true;
				case 'p': case 'P':
					pause ^= 1;
					singleStep = 0;
					return true;
				case 's': case 'S':
					if (sim->getUseShadows()) sim->setUseShadows(false);
					else sim->setUseShadows(true);
					return true;
				case 't': case 'T':
					if (sim->getUseTextures()) sim->setUseTextures(false);
					else sim->setUseTextures(true);
					//printf("textures true\n");
					return true;
				case 'v': case 'V':
					{
						float xyz[3],hpr[3];
						diGetViewpoint (xyz,hpr);
						printf ("Viewpoint = (%.4f,%.4f,%.4f,%.4f,%.4f,%.4f)\n",
							xyz[0],xyz[1],xyz[2],hpr[0],hpr[1],hpr[2]);
						break;
					}
				case 'x': case 'X':
					sim->setRun2(false);
					return true;
				}
			}
			else
			{
				switch (CURRENT_KEY)
				{
				case KEY_ESCAPE:
					idevice->closeDevice();
					return true;
				case KEY_LEFT:
					sim->vision->view_xyz[0] -= 0.1f;
					// showInfo("xyz=",sim->vision->view_xyz);				
					return true;
				case KEY_RIGHT:
					sim->vision->view_xyz[0] += 0.1f;
					// showInfo("xyz=",sim->vision->view_xyz);		
					return true;
				case KEY_UP:
					sim->vision->view_xyz[2] -= 0.1f;
					// showInfo("xyz=",sim->vision->view_xyz);		
					return true;
				case KEY_DOWN:
					sim->vision->view_xyz[2] += 0.1f;
					// showInfo("xyz=",sim->vision->view_xyz);		
					return true;
				case '1':
					sim->vision->view_xyz[1] -= 0.1f;
					// showInfo("xyz=",sim->vision->view_xyz);		
					return true;
				case '2':
					sim->vision->view_xyz[1] += 0.1f;
					// showInfo("xyz=",sim->vision->view_xyz);		
					return true;
				case '3':
					sim->vision->view_xyz[1] -= 0.1f;
					// showInfo("xyz=",sim->vision->view_xyz);		
					return true;
				case '4':
					sim->vision->view_xyz[1] += 0.1f;
					// showInfo("xyz=",sim->vision->view_xyz);		
					return true;
				case '5':
					sim->vision->view_hpr[0] += 1.0f;
					sim->vision->wrapCameraAngles(sim->vision->view_hpr);
					// showInfo("hpr=",sim->vision->view_hpr);		
					return true;
				case '6':
					sim->vision->view_hpr[0] -= 1.0f;
					sim->vision->wrapCameraAngles(sim->vision->view_hpr);
					// showInfo("hpr=",sim->vision->view_hpr);		
					return true;
				case '7':
					sim->vision->view_hpr[1] += 1.0f;
					sim->vision->wrapCameraAngles(sim->vision->view_hpr);
					// showInfo("hpr=",sim->vision->view_hpr);		
					return true;
				case '8':
					sim->vision->view_hpr[1] -= 1.0f;
					sim->vision->wrapCameraAngles(sim->vision->view_hpr);
					// showInfo("hpr=",sim->vision->view_hpr);		
					return true;
				case '9':
					sim->vision->view_hpr[2] += 1.0f;
					sim->vision->wrapCameraAngles(sim->vision->view_hpr);
					// showInfo("hpr=",sim->vision->view_hpr);		
					return true;
				case '0':
					sim->vision->view_hpr[2] -= 1.0f;
					sim->vision->wrapCameraAngles(sim->vision->view_hpr);
					// showInfo("hpr=",sim->vision->view_hpr);		
					return true;
				default:
					keyFunction(fn2);
					return true;
				}
			}
		}
		else
		{
			CURRENT_KEY = 0;
		}
		return false;
	}
	else
	{
		// mouse event
		if (event.EventType == EET_MOUSE_INPUT_EVENT) 
		{      
			int msg = event.MouseInput.Event;
			switch (msg)
			{
			case EMIE_LMOUSE_PRESSED_DOWN:
			case EMIE_MMOUSE_PRESSED_DOWN:
			case EMIE_RMOUSE_PRESSED_DOWN:
				if (msg==EMIE_LMOUSE_PRESSED_DOWN) mode |= 1;
				else if (msg==EMIE_MMOUSE_PRESSED_DOWN) mode |= 2;
				else mode |= 4;
				mx = event.MouseInput.X;
				my = event.MouseInput.Y;
				break;
			case EMIE_LMOUSE_LEFT_UP:
			case EMIE_RMOUSE_LEFT_UP:			
			case EMIE_MMOUSE_LEFT_UP:
				if (msg==EMIE_LMOUSE_LEFT_UP) mode &= (~1);
				else if (msg==EMIE_MMOUSE_LEFT_UP) mode &= (~2);
				else mode &= (~4);
				//mx = event.MouseInput.X;
				//my = event.MouseInput.Y;
			    break;
			case EMIE_MOUSE_MOVED:
				//printf("mode=%d \n", mode);
				if (mode != 0)
				{
					diMotion(mode, event.MouseInput.X - mx, event.MouseInput.Y- my);
					mx = event.MouseInput.X;
					my = event.MouseInput.Y;
				}
				break;
			case EMIE_MOUSE_WHEEL:
				//上回転
				if (event.MouseInput.Wheel == 1)
				{
					mx++;
				}
				//下回転
				else if (event.MouseInput.Wheel == -1)
				{
					mx--;
				}
				break;
			case EMIE_COUNT:
				break;
			default:
				return false;
			}
		}
	}	

	if (event.EventType == EET_GUI_EVENT)
	{
		s32 id = event.GUIEvent.Caller->getID();
		IGUIEnvironment* env = idevice->getGUIEnvironment();

		switch(event.GUIEvent.EventType)
		{
		case EGET_MENU_ITEM_SELECTED:
			{
				// a menu item was clicked
				IGUIContextMenu* menu = (IGUIContextMenu*) event.GUIEvent.Caller;
				s32 id = menu->getItemCommandId(menu->getSelectedItem());

				switch(id)
				{
				case GUI_ID_OPEN_MODEL: // File -> Open Model
					env->addFileOpenDialog(L"Please select a model file to open");
					break;
				case GUI_ID_QUIT: // File -> Quit
					idevice->closeDevice();
					break;
				case GUI_ID_PAUSE: // Simulation -> Pause
					pause ^= 1;
					if (pause) singleStep = 1;
					break;
				case GUI_ID_SINGLE_STEP: // Simulation -> Single Step
					if (pause) singleStep = 1;
					break;
				case GUI_ID_MONITOR: // Simulation -> Performance Monitor
					break;
				case GUI_ID_SHADOWS: // Simulation -> Shadows
					if (sim->getUseShadows()) sim->setUseShadows(false);
					else sim->setUseShadows(true);                  
					break;
				case GUI_ID_TEXTURES: // Simulation -> Textures
					if (sim->getUseTextures()) sim->setUseTextures(false);
					else sim->setUseTextures(true);                  
					break;
				case GUI_ID_SAVE_SETTINGS: // Simulation -> Save Settings
					break;
				case GUI_ID_ABOUT: // Help->About
					showAboutText();
					break;
					/* case GUI_ID_CAMERA_MAYA:
					setActiveCamera(Camera[0]);
					break;
					case GUI_ID_CAMERA_FIRST_PERSON:
					setActiveCamera(Camera[1]);
					break;
					*/
				}
				break;
			}
		case EGET_FILE_SELECTED:
			{
				// load the model file, selected in the file open dialog
				IGUIFileOpenDialog* dialog = (IGUIFileOpenDialog*)event.GUIEvent.Caller;
				sim->misc->loadModel(core::stringc(dialog->getFileName()).c_str());
			}
			break;
		default:
			break;
		}
		return false;
	}	
	return false;
}

// キー関数　大文字，小文字を区別をしない; Key function
void idsEventReceiver::keyFunction(diFunctions *fn)
{
    static int tmp_key;

    if (fn->command)
    {
        fn->command(CURRENT_KEY);
        if (CURRENT_KEY >= 188)
        {
            tmp_key = CURRENT_KEY - 144;
            fn->command(tmp_key);
        }
        else
        {
            if (('A' <= CURRENT_KEY) && (CURRENT_KEY <= 'Z'))
            {
                tmp_key = CURRENT_KEY + ('a' - 'A');
                fn->command(tmp_key);
            }
        }
    }
}

// ヘルプでのテキスト表示; show about text 
void idsEventReceiver::showAboutText()
{
	idevice->getGUIEnvironment()->addMessageBox(
		L"About", L"irrDrawstuff \n\n Change the camera position by clicking + dragging in the window.\n       Left button - pan and tilt.\n       Right button - forward and sideways.\n       Left + Right button (or middle button) - sideways and up.\n", true);
}
