// Copyright (C) 2010 Kosei Demura
// This file is part of the irrDrawStuff library.
// Please read copyright notice in irrdrawstuff.h for conditions of distribution and usage.
// マウス，キーボードなどのイベント処理のクラス

#ifndef __IDS_EVENT_RECEIVER_H
#define __IDS_EVENT_RECEIVER_H

#include "simLoop.h"

class idsEventReceiver : public IEventReceiver
{
public:
    idsEventReceiver(); 
	~idsEventReceiver();
	virtual bool OnEvent(const SEvent& event);  
	void init(IrrlichtDevice *device, diFunctions *fn, int init_pause);
    void keyFunction(diFunctions *fn);
	void showAboutText();
	void setPause(int a);
	int  getPause();
	void setSingleStep(int a);
	int  getSingleStep();
private:
	IrrlichtDevice *idevice;
	diFunctions *fn2;  // diFunctions構造体のコピー
	int pause;         // 1: simulation pause
	int singleStep;   // true: single step
    int mx,my;
    int mode;
	void showInfo(char* str, float info[3]);
};

enum GuiObject
{
	GUI_ID_OPEN_MODEL,
	GUI_ID_QUIT,
	GUI_ID_PAUSE,
	GUI_ID_SINGLE_STEP,
	GUI_ID_MONITOR,
	GUI_ID_SHADOWS,
	GUI_ID_TEXTURES,
	GUI_ID_SAVE_SETTINGS,
	GUI_ID_ABOUT
};

#endif
