// Copyright (C) 2010 Kosei Demura
// This file is part of the irrDrawStuff library.
// Please read copyright notice in irrdrawstuff.h for conditions of distribution and usage. 
// カプセル，シリンダなどirrlichtにない基本形状に関するクラス

#ifndef __IDS_SCENENODE_H
#define __IDS_SCENENODE_H

#include "simLoop.h"

// ボックスシーンノード, idsBox Scene Node
class idsBoxSceneNode : public scene::ISceneNode
{
public:
    idsBoxSceneNode(f32 sides[3], scene::ISceneNode* parent, scene::ISceneManager*mgr, s32 id);
	~idsBoxSceneNode();
    virtual void OnRegisterSceneNode(); 
    virtual void render();   
    virtual const core::aabbox3d<f32>& getBoundingBox() const;
    virtual u32 getMaterialCount() const;
    virtual video::SMaterial& getMaterial(u32 i); 
private:
	core::aabbox3d<f32> boundingBox;
    video::S3DVertex vertices[8];
    video::SMaterial material;
    f32 sides[3];
};

// カプセルシーンノード, idsCapsule Scene Node
class idsCapsuleSceneNode : public scene::ISceneNode
{
public:
    idsCapsuleSceneNode(f32 l, f32 r, scene::ISceneNode *parent, scene::ISceneManager *mgr, s32 id);
	~idsCapsuleSceneNode();
    virtual void OnRegisterSceneNode();
    virtual void render();
    virtual const core::aabbox3d<f32>& getBoundingBox() const;
    virtual u32 getMaterialCount() const;
    virtual video::SMaterial& getMaterial(u32 i);
private:
    core::aabbox3d<f32> boundingBox;
    video::S3DVertex vertices[8];
    video::SMaterial material;
    f32 length;
    f32 radius;
};


// シリンダシーンノード, idsCylinder Scene Node
class idsCylinderSceneNode : public scene::ISceneNode
{
public:
    idsCylinderSceneNode(f32 l, f32 r, scene::ISceneNode* parent, scene::ISceneManager*mgr, s32 id);
	~idsCylinderSceneNode();
    virtual void OnRegisterSceneNode();
    virtual void render();
    virtual const core::aabbox3d<f32>& getBoundingBox() const;
    virtual u32 getMaterialCount() const;
    virtual video::SMaterial& getMaterial(u32 i);
private:
	core::aabbox3d<f32> boundingBox;
    video::S3DVertex vertices[8];
    video::SMaterial material;
    f32 length;
    f32 radius;
};

#endif
