// Copyright (C) 2010 Kosei Demura
// This file is part of the irrDrawStuff library.
// Please read copyright notice in irrdrawstuff.h for conditions of distribution and usage.

// irrDrawStuffの内部では基本的にirrlichtの座標系を使用する

#ifndef __SIMLOOP_H
#define __SIMLOOP_H

#include <iostream>
#include <assert.h>

#ifdef WIN32
#include <windows.h>
#include <mmsystem.h>
#pragma comment(lib, "winmm.lib")
#pragma comment(lib, "Irrlicht.lib")
static HWND main_window = 0;
#endif

#ifndef WIN32
#include <sys/time.h>
#endif

#ifdef _MSC_VER
#pragma warning(disable:4244 4305 4819)  // for VC++, no precision loss complaints
#endif

#include <ode/ode.h>
#include <irrdrawstuff.h>
#include "iomanip"

class DrawPrimitives;
class DrawMesh;
class Misc;
class Vision;

#ifndef M_PI
#define M_PI (3.14159265358979323846)
#endif

using namespace std;

template <class T>
inline void safe_delete(T*& p)
{
	delete p;
	p = 0;
};

template <class T>
inline void safe_delete_array(T*& p)
{
	delete[] p;
	p = 0;
};

class SimLoop
{
public:
	static SimLoop* getInstance()
	{
		static SimLoop instance;
		return &instance;
	}
	void init();
	int  getCurrentState();
	void setCurrentState(int state);
	bool getUseShadows();
	void setUseShadows(bool a);
	bool getUseTextures();
	void setUseTextures(bool a);
	bool getRun2();
	void setRun2(bool a);
	double getFrameCount();
	void diPlatformSimLoop(int window_width,int window_height, diFunctions* fn,int initial_pause);
	void diStartGraphics(int width, int height, diFunctions *fn);

	DrawPrimitives *pri;
	DrawMesh *mesh;
	Misc *misc;
	Vision *vision;

private:
	// Singleton
	SimLoop(){};
	SimLoop(const SimLoop&);
	SimLoop& operator=(const SimLoop&);

	irr::IrrlichtDevice *device;
	irr::video::IVideoDriver *driver;
	irr::scene::ISceneManager *smgr;
	irr::gui::IGUIEnvironment *env;
	int currentState; // 現在の状態
	bool useTextures;  // true if textures to be drawn
	bool useShadows;  // true if shadows to be drawn
	bool run2;        // true if simulation run

	double frameCount;   // 描画フレーム数
	void diDrawFrame(int width, int height, diFunctions *fn, int pause);
	void showUsage();
	void createSetupDevice(const int window_width, const int window_height);
	void createSetupGUI();
	double elapsedTime();
};

#endif
