// Copyright (C) 2010 Kosei Demura
// This file is part of the irrDrawStuff library.
// Please read copyright notice in irrdrawstuff.h for conditions of distribution and usage. 
// 視覚関係（カメラと照明）のクラス．

#ifndef __IDS_VISION_H
#define __IDS_VISION_H

#include "simLoop.h"

class Vision
{
public:
	// 座標系の基準はirrlicht, ODEの場合は明記すること
	float view_xyz[3]; // 視点．irrlicht座標系　
	float view_hpr[3]; // 視線方向．irrlicht座標系
	float view_ode_xyz[3]; // 視点．ODE	座標系
	float view_ode_hpr[3]; // 視線方向, ODE座標系
	float view_old_xyz[3]; // 視点．視線方向．irrlicht座標系　
	float view_old_hpr[3]; // 視線方向．irrlicht座標系

	Vision(irr::scene::ISceneManager *smgr);
	~Vision();
	float getLightX();
	float getLightZ();
	void createSetupLight();
	void createSetupCamera();

	void calcTargetPoint(float *target_x, float *target_y, float *target_z,
                            float x, float y, float z, float heading, float pitch, float roll);
	void setupCamera(int width, int height);
	void wrapCameraAngles(float view_hpr[3]);
	void setViewpoint(float xyz[3], float hpr[3]);
	void getViewpoint(float xyz[3], float hpr[3]);	
	irr::scene::ICameraSceneNode *getCamera();
	irr::scene::ILightSceneNode  *getLight(); 

private:
	irr::scene::ISceneManager *ismgr;
	irr::scene::ISceneNode *targetNode;
	irr::scene::ISceneNode *cameraman; //カメラのターゲット
	irr::scene::ILightSceneNode  *light; 
	irr::scene::ICameraSceneNode *camera;

	// Irrlicht light vector. gLightY is implicitly 1
	// 光源ベクトル(irrlicht座標系）
	float lightX;
	float lightZ;
	void calcUpVector(float *up_x, float *up_y, float *up_z,
                         float heading, float pitch, float roll);
	void setCamera(float x, float y, float z);
};

#endif

