﻿Imports Microsoft.Kinect
Imports System

Module Program

    Sub Main(args() As String)
        If KinectSensor.KinectSensors.Count > 0 Then
            'センサーのインスタンスを作成する
            Dim sensor As KinectSensor = KinectSensor.KinectSensors(0)

            'カメラを初期化する
            sensor.DepthStream.Enable()
            AddHandler sensor.DepthFrameReady, AddressOf sensor_DepthFrameReady

            'マトリックスのように表示する
            Console.ForegroundColor = ConsoleColor.Green

            'データストリームを開始する
            sensor.Start()
            Do While (Console.ReadKey().Key <> ConsoleKey.Spacebar)

            Loop
        Else
            Console.WriteLine("Kinectセンサーを接続してください。")
        End If
    End Sub

    Private Sub sensor_DepthFrameReady(sender As Object, e As DepthImageFrameReadyEventArgs)
        Using depthFrame As Microsoft.Kinect.DepthImageFrame = e.OpenDepthImageFrame
            If depthFrame Is Nothing Then
                Exit Sub
            End If
            Dim bits(depthFrame.PixelDataLength - 1) As Short
            depthFrame.CopyPixelDataTo(bits)
            For Each bit As Short In bits
                Console.Write(bit)
            Next
        End Using
    End Sub
End Module
