﻿Imports System
Imports System.Linq
Imports System.Windows
Imports System.Windows.Media
Imports System.Windows.Media.Imaging
Imports System.ComponentModel

Imports Microsoft.Kinect

''' <summary>
''' Interaction logic for MainWindow.xaml
''' </summary>
''' <remarks></remarks>
Class MainWindow
#Region "メンバー変数"
    Private _Kinect As KinectSensor
    Private _ColorImageBitmap As WriteableBitmap
    Private _ColorImageBitmapRect As Int32Rect
    Private _ColorImageStride As Integer
    Private _ColorImagePixelData() As Byte
    Private _Worker As BackgroundWorker
#End Region

#Region "コンストラクタ"
    Sub New()

        ' この呼び出しはデザイナーで必要です。
        InitializeComponent()

        ' InitializeComponent() 呼び出しの後で初期化を追加します。
        Me._Worker = New BackgroundWorker()
        AddHandler Me._Worker.DoWork, AddressOf Worker_DoWork
        Me._Worker.RunWorkerAsync()

        AddHandler Me.Unloaded, Sub(s, e)
                                    Me._Worker.CancelAsync()
                                End Sub
    End Sub
#End Region

    ' Listing 2-14
    Private Sub DiscoverKinectSensor()
        If Me._Kinect IsNot Nothing AndAlso Me._Kinect.Status <> KinectStatus.Connected Then
            Me._Kinect = Nothing
        End If

        If Me._Kinect Is Nothing Then
            Me._Kinect = KinectSensor.KinectSensors.FirstOrDefault(Function(x)
                                                                       Return x.Status = KinectStatus.Connected
                                                                   End Function)

            If Me._Kinect IsNot Nothing Then
                Me._Kinect.ColorStream.Enable()
                Me._Kinect.Start()

                Dim colorStream As ColorImageStream = Me._Kinect.ColorStream

                Me.ColorImageElement.Dispatcher.BeginInvoke(New Action(Sub()
                                                                           Me._ColorImageBitmap = New WriteableBitmap(colorStream.FrameWidth,
                                                                                                                      colorStream.FrameHeight,
                                                                                                                      96,
                                                                                                                      96,
                                                                                                                      PixelFormats.Bgr32,
                                                                                                                      Nothing)
                                                                           Me._ColorImageBitmapRect = New Int32Rect(0,
                                                                                                                    0,
                                                                                                                    colorStream.FrameWidth,
                                                                                                                    colorStream.FrameHeight)
                                                                           Me._ColorImageStride = colorStream.FrameWidth * colorStream.FrameBytesPerPixel
                                                                           ReDim Me._ColorImagePixelData(colorStream.FramePixelDataLength - 1)

                                                                           Me.ColorImageElement.Source = Me._ColorImageBitmap
                                                                       End Sub))
            End If
        End If
    End Sub

    Private Sub PollColorImageStream()
        If Me._Kinect Is Nothing Then
            'TODO:使用可能なセンサーが存在しないことを通知する
        Else
            Try
                Using Frame As ColorImageFrame = Me._Kinect.ColorStream.OpenNextFrame(100)
                    If Frame IsNot Nothing Then
                        Frame.CopyPixelDataTo(Me._ColorImagePixelData)

                        Me.ColorImageElement.Dispatcher.BeginInvoke(New Action(Sub()
                                                                                   Me._ColorImageBitmap.WritePixels(Me._ColorImageBitmapRect,
                                                                                                                    Me._ColorImagePixelData,
                                                                                                                    Me._ColorImageStride,
                                                                                                                    0)
                                                                               End Sub))
                    End If
                End Using
            Catch ex As Exception
                'TODO:エラーメッセージをレポートする
            End Try
        End If
    End Sub

    Private Sub Worker_DoWork(sender As Object, e As DoWorkEventArgs)
        Dim worker As BackgroundWorker = CType(sender, BackgroundWorker)
        If worker IsNot Nothing Then
            Do While Not worker.CancellationPending
                DiscoverKinectSensor()
                PollColorImageStream()
            Loop
        End If
    End Sub

End Class
