﻿Imports System

Public Class PlayerDepthData
#Region "メンバー変数"
    Private Shared ReadOnly HorizontalTanA As Double = Math.Tan(57.0 / 2.0 * Math.PI / 180)
    Private Shared ReadOnly  VerticalTanA As Double = Math.Abs(Math.Tan(43.0 / 2.0 * Math.PI / 180))

    Private _DepthSum As Integer
    Private _DepthCount As Integer
    Private _LoWidth As Integer
    Private _HiWidth As Integer
    Private _LoHeight As Integer
    Private _HiHeight As Integer
#End Region


#Region "コンストラクタ"
    Sub New(playerId As Integer, frameWidth As Double, frameHeight As Double)
        Me.PlayerId = playerId
        Me.FrameWidth = frameWidth
        Me.FrameHeight = frameHeight


        Me._LoWidth = Integer.MaxValue
        Me._HiWidth = Integer.MinValue

        Me._LoHeight = Integer.MaxValue
        Me._HiHeight = Integer.MinValue
    End Sub
#End Region


#Region "メソッド"
    Public Sub UpdateData(x As Integer, y As Integer, depth As Integer)
        Me._DepthCount += 1
        Me._DepthSum += depth
        Me._LoWidth = Math.Min(Me._LoWidth, x)
        Me._HiWidth = Math.Max(Me._HiWidth, x)
        Me._LoHeight = Math.Min(Me._LoHeight, y)
        Me._HiHeight = Math.Max(Me._HiHeight, y)
    End Sub
#End Region


#Region "プロパティ"
    Public Property PlayerId As Integer
    Public Property FrameWidth As Double
    Public Property FrameHeight As Double

    Public ReadOnly Property Depth As Double
        Get
            Return Me._DepthSum / CType(Me._DepthCount, Double)
        End Get
    End Property

    Public ReadOnly Property PixelWidth As Integer
        Get
            Return Me._HiWidth - Me._LoWidth
        End Get
    End Property

    Public ReadOnly Property PixelHeight As Integer
        Get
            Return Me._HiHeight - Me._LoHeight
        End Get
    End Property

    Public ReadOnly Property RealWidth As String
        Get
            Dim opposite As Double = Me.Depth * HorizontalTanA
            Dim meter As Double = Me.PixelWidth * 2 * opposite / Me.FrameWidth
            Return String.Format("{0:0}mm", meter)
        End Get
    End Property

    Public ReadOnly Property RealHeight As String
        Get
            Dim opposite As Double = Me.Depth * VerticalTanA
            Dim meter As Double = Me.PixelHeight * 2 * opposite / Me.FrameHeight
            Return String.Format("{0:0}mm", meter)
        End Get
    End Property
#End Region
End Class
