﻿Imports System.Windows
Imports System
Imports System.Windows.Threading
Imports Beginning.Kinect.Framework.Input

Namespace Controls
    ''' <summary>
    ''' TODO: Update summary.
    ''' </summary>
    Public Class HoverButton
        Inherits KinectButton
        ReadOnly _hoverTimer As DispatcherTimer = New DispatcherTimer()
        Protected _timerEnabled As Boolean = True

        ''' <summary>
        ''' Gets or sets the amount of time required for a hover to trigger the click event.
        ''' </summary>
        ''' <value>
        ''' The hover interval.
        ''' </value>
        Public Property HoverInterval As Double
            Get
                Return CType(GetValue(HoverIntervalProperty), Double)
            End Get
            Set(value As Double)
                SetValue(HoverIntervalProperty, value)
            End Set
        End Property

        ' Using a DependencyProperty as the backing store for HoverInterval.  Me enables animation, styling, binding, etc...
        Public Shared ReadOnly HoverIntervalProperty As DependencyProperty =
            DependencyProperty.Register("HoverInterval",
                                        GetType(Double),
                                        GetType(HoverButton),
                                        New UIPropertyMetadata(2000.0R))

        Public Sub New()
            _hoverTimer.Interval = TimeSpan.FromMilliseconds(HoverInterval)
            AddHandler _hoverTimer.Tick, AddressOf _hoverTimer_Tick
            _hoverTimer.Stop()
        End Sub


        Protected Overrides Sub OnKinectCursorEnter(sender As Object, e As KinectCursorEventArgs)
            If (_timerEnabled) Then
                _hoverTimer.Interval = TimeSpan.FromMilliseconds(HoverInterval)
                e.Cursor.AnimateCursor(HoverInterval)
                _hoverTimer.Start()
            End If
        End Sub


        Protected Overrides Sub OnKinectCursorLeave(sender As Object, e As KinectCursorEventArgs)
            If (_timerEnabled) Then
                e.Cursor.StopCursorAnimation()
                _hoverTimer.Stop()
            End If
        End Sub

        Sub _hoverTimer_Tick(sender As Object, e As EventArgs)
            _hoverTimer.Stop()
            MyBase.RaiseEvent(New RoutedEventArgs(ClickEvent))
        End Sub
    End Class
End Namespace
