﻿Imports System.Windows.Controls
Imports Beginning.Kinect.Framework.Input
Imports System.Windows

Namespace Controls
    Public Class KinectButton
        Inherits Button
        Public Shared ReadOnly KinectCursorEnterEvent As RoutedEvent = KinectInput.KinectCursorEnterEvent.AddOwner(GetType(KinectButton))
        Public Shared ReadOnly KinectCursorLeaveEvent As RoutedEvent = KinectInput.KinectCursorLeaveEvent.AddOwner(GetType(KinectButton))
        Public Shared ReadOnly KinectCursorMoveEvent As RoutedEvent = KinectInput.KinectCursorMoveEvent.AddOwner(GetType(KinectButton))
        Public Shared ReadOnly KinectCursorActivatedEvent As RoutedEvent = KinectInput.KinectCursorActivatedEvent.AddOwner(GetType(KinectButton))
        Public Shared ReadOnly KinectCursorDeactivatedEvent As RoutedEvent = KinectInput.KinectCursorDeactivatedEvent.AddOwner(GetType(KinectButton))


#Region "アクセサ付イベント"
        Private _KinectCursorEnter As KinectCursorEventHandler
        Public Custom Event KinectCursorEnter As KinectCursorEventHandler
            AddHandler(value As KinectCursorEventHandler)
                Me._KinectCursorEnter = CType(System.Delegate.Combine(Me._KinectCursorEnter, value), KinectCursorEventHandler)
            End AddHandler

            RemoveHandler(value As KinectCursorEventHandler)
                Me._KinectCursorEnter = CType(System.Delegate.Remove(Me._KinectCursorEnter, value), KinectCursorEventHandler)
            End RemoveHandler

            RaiseEvent(sender As Object, e As KinectCursorEventArgs)
                If Not Me._KinectCursorEnter Is Nothing Then
                    Me._KinectCursorEnter(sender, e)
                End If
            End RaiseEvent
        End Event

        Private _KinectCursorLeave As KinectCursorEventHandler
        Public Custom Event KinectCursorLeave As KinectCursorEventHandler
            AddHandler(value As KinectCursorEventHandler)
                Me._KinectCursorLeave = CType(System.Delegate.Combine(Me._KinectCursorLeave, value), KinectCursorEventHandler)
            End AddHandler

            RemoveHandler(value As KinectCursorEventHandler)
                Me._KinectCursorLeave = CType(System.Delegate.Remove(Me._KinectCursorLeave, value), KinectCursorEventHandler)
            End RemoveHandler

            RaiseEvent(sender As Object, e As KinectCursorEventArgs)
                If Not Me._KinectCursorLeave Is Nothing Then
                    Me._KinectCursorLeave(sender, e)
                End If
            End RaiseEvent
        End Event

        Private _KinectCursorMove As KinectCursorEventHandler
        Public Custom Event KinectCursorMove As KinectCursorEventHandler
            AddHandler(value As KinectCursorEventHandler)
                Me._KinectCursorMove = CType(System.Delegate.Combine(Me._KinectCursorMove, value), KinectCursorEventHandler)
            End AddHandler

            RemoveHandler(value As KinectCursorEventHandler)
                Me._KinectCursorMove = CType(System.Delegate.Remove(Me._KinectCursorMove, value), KinectCursorEventHandler)
            End RemoveHandler

            RaiseEvent(sender As Object, e As KinectCursorEventArgs)
                If Not Me._KinectCursorMove Is Nothing Then
                    Me._KinectCursorMove(sender, e)
                End If
            End RaiseEvent
        End Event

        Private _KinectCursorActivated As RoutedEventHandler
        Public Custom Event KinectCursorActivated As RoutedEventHandler
            AddHandler(value As RoutedEventHandler)
                Me._KinectCursorActivated = CType(System.Delegate.Combine(Me._KinectCursorActivated, value), RoutedEventHandler)
            End AddHandler

            RemoveHandler(value As RoutedEventHandler)
                Me._KinectCursorActivated = CType(System.Delegate.Remove(Me._KinectCursorActivated, value), RoutedEventHandler)
            End RemoveHandler

            RaiseEvent(sender As Object, e As RoutedEventArgs)
                If Not Me._KinectCursorActivated Is Nothing Then
                    Me._KinectCursorActivated(sender, e)
                End If
            End RaiseEvent
        End Event

        Private _KinectCursorDeactivated As RoutedEventHandler
        Public Custom Event KinectCursorDeactivated As RoutedEventHandler
            AddHandler(value As RoutedEventHandler)
                Me._KinectCursorDeactivated = CType(System.Delegate.Combine(Me._KinectCursorDeactivated, value), RoutedEventHandler)
            End AddHandler

            RemoveHandler(value As RoutedEventHandler)
                Me._KinectCursorDeactivated = CType(System.Delegate.Remove(Me._KinectCursorDeactivated, value), RoutedEventHandler)
            End RemoveHandler

            RaiseEvent(sender As Object, e As RoutedEventArgs)
                If Not Me._KinectCursorDeactivated Is Nothing Then
                    Me._KinectCursorDeactivated(sender, e)
                End If
            End RaiseEvent
        End Event
#End Region

        Public Sub New()
            'autogen the manager if needed
            If (Not System.ComponentModel.DesignerProperties.GetIsInDesignMode(Me)) Then
                KinectCursorManager.Create(Application.Current.MainWindow)
            End If
            AddHandler Me.KinectCursorEnter, New KinectCursorEventHandler(AddressOf OnKinectCursorEnter)
            AddHandler Me.KinectCursorLeave, New KinectCursorEventHandler(AddressOf OnKinectCursorLeave)
            AddHandler Me.KinectCursorMove, New KinectCursorEventHandler(AddressOf OnKinectCursorMove)
            AddHandler Me.KinectCursorActivated, New RoutedEventHandler(AddressOf OnKinectCursorActivated)
            AddHandler Me.KinectCursorDeactivated, New RoutedEventHandler(AddressOf OnKinectCursorDeactivated)
        End Sub

        Protected Overridable Sub OnKinectCursorEnter(sender As Object, e As KinectCursorEventArgs)
            MyBase.RaiseEvent(New RoutedEventArgs(ClickEvent))
        End Sub

        Protected Overridable Sub OnKinectCursorLeave(sender As Object, e As KinectCursorEventArgs)

        End Sub

        Protected Overridable Sub OnKinectCursorMove(sender As Object, e As KinectCursorEventArgs)

        End Sub

        Protected Overridable Sub OnKinectCursorActivated(sender As Object, e As RoutedEventArgs)

        End Sub

        Protected Overridable Sub OnKinectCursorDeactivated(sender As Object, e As RoutedEventArgs)

        End Sub

    End Class
End Namespace