﻿Imports System
Imports System.Windows
Imports Beginning.Kinect.Framework.Input

Namespace Controls
    Public Class MagneticSlide
        Inherits MagnetButton

        Public Sub New()
            MyBase._isLockOn = IsMagnetOn
            MyBase._timerEnabled = False
        End Sub

        Private _isLookingForSwipes As Boolean

        Private Sub InitializeSwipe()
            If (_isLookingForSwipes) Then
                Exit Sub
            End If
            'Debug.WriteLine("initialize swipe")
            _isLookingForSwipes = True
            Dim kinectMgr As KinectCursorManager = KinectCursorManager.Instance
            kinectMgr.GesturePointTrackingInitialize(SwipeLength, MaxDeviation, MaxSwipeTime, XOutOfBoundsLength)
            AddHandler kinectMgr.SwipeDetected, AddressOf kinectMgr_SwipeDetected
            AddHandler kinectMgr.SwipeOutOfBoundsDetected, AddressOf kinectMgr_SwipeOutOfBoundsDetected
            KinectCursorManager.Instance.GesturePointTrackingStart()
        End Sub

        Private Sub DeInitializeSwipe()
            'Debug.WriteLine("deinitialize swipe")
            _isLookingForSwipes = False
            Dim kinectMgr As KinectCursorManager = KinectCursorManager.Instance
            kinectMgr.GesturePointTrackingStop()
            RemoveHandler kinectMgr.SwipeDetected, AddressOf kinectMgr_SwipeDetected
            RemoveHandler kinectMgr.SwipeOutOfBoundsDetected, AddressOf kinectMgr_SwipeOutOfBoundsDetected
        End Sub


        Public Shared ReadOnly SwipeOutOfBoundsEvent As RoutedEvent =
            EventManager.RegisterRoutedEvent("SwipeOutOfBounds",
                                             RoutingStrategy.Bubble,
                                             GetType(KinectCursorEventHandler),
                                             GetType(KinectInput))

        Private _SwipeOutOfBounds As RoutedEventHandler
        Public Custom Event SwipeOutOfBounds As RoutedEventHandler
            AddHandler(value As RoutedEventHandler)
                MyBase.AddHandler(SwipeOutOfBoundsEvent, value)
                'Me._SwipeOutOfBounds = CType(System.Delegate.Combine(Me._SwipeOutOfBounds, value), RoutedEventHandler)
            End AddHandler

            RemoveHandler(value As RoutedEventHandler)
                MyBase.RemoveHandler(SwipeOutOfBoundsEvent, value)
                'Me._SwipeOutOfBounds = CType(System.Delegate.Remove(Me._SwipeOutOfBounds, value), RoutedEventHandler)
            End RemoveHandler

            RaiseEvent(sender As Object, e As System.Windows.RoutedEventArgs)
                'If Not Me._SwipeOutOfBounds Is Nothing Then
                '    Me._SwipeOutOfBounds.Invoke(sender, e)
                'End If
            End RaiseEvent
        End Event

        Sub kinectMgr_SwipeOutOfBoundsDetected(sender As Object, e As Input.KinectCursorEventArgs)
            DeInitializeSwipe()
            MyBase.RaiseEvent(New KinectCursorEventArgs(SwipeOutOfBoundsEvent))
        End Sub

        Sub kinectMgr_SwipeDetected(sender As Object, e As Input.KinectCursorEventArgs)
            DeInitializeSwipe()
            MyBase.RaiseEvent(New RoutedEventArgs(ClickEvent))
        End Sub

        Protected Overrides Sub OnKinectCursorEnter(sender As Object, e As Input.KinectCursorEventArgs)
            InitializeSwipe()
            MyBase.OnKinectCursorEnter(sender, e)
        End Sub


        ' Using a DependencyProperty as the backing store for IsMagnetOn.  Me enables animation, styling, binding, etc...
        Public Shared ReadOnly IsMagnetOnProperty As DependencyProperty =
            DependencyProperty.Register("IsMagnetOn",
                                        GetType(Boolean),
                                        GetType(MagneticSlide),
                                        New UIPropertyMetadata(True))

        Public Property IsMagnetOn As Boolean
            Get
                Return CType(GetValue(IsMagnetOnProperty), Boolean)
            End Get
            Set(value As Boolean)
                SetValue(IsMagnetOnProperty, value)
            End Set
        End Property

        ' Using a DependencyProperty as the backing store for IsMagnetOn.  Me enables animation, styling, binding, etc...
        Public Shared ReadOnly SwipeLengthProperty As DependencyProperty =
            DependencyProperty.Register("SwipeLength",
                                        GetType(Double),
                                        GetType(MagneticSlide),
                                        New UIPropertyMetadata(-500.0R))

        Public Property SwipeLength As Double
            Get
                Return CType(GetValue(SwipeLengthProperty), Double)
            End Get
            Set(value As Double)
                SetValue(SwipeLengthProperty, value)
            End Set
        End Property

        ' Using a DependencyProperty as the backing store for MaxYDeviation.  Me enables animation, styling, binding, etc...
        Public Shared ReadOnly MaxDeviationProperty As DependencyProperty =
            DependencyProperty.Register("MaxDeviation",
                                        GetType(Double),
                                        GetType(MagneticSlide),
                                        New UIPropertyMetadata(100.0R))

        Public Property MaxDeviation As Double
            Get
                Return CType(GetValue(MaxDeviationProperty), Double)
            End Get
            Set(value As Double)
                SetValue(MaxDeviationProperty, value)
            End Set
        End Property

        ' Using a DependencyProperty as the backing store for XOutOfBound.  Me enables animation, styling, binding, etc...
        Public Shared ReadOnly XOutOfBoundsLengthProperty As DependencyProperty =
            DependencyProperty.Register("XOutOfBoundsLength",
                                        GetType(Double),
                                        GetType(MagneticSlide),
                                        New UIPropertyMetadata(-700.0R))

        Public Property XOutOfBoundsLength As Double
            Get
                Return CType(GetValue(XOutOfBoundsLengthProperty), Double)
            End Get
            Set(value As Double)
                SetValue(XOutOfBoundsLengthProperty, value)
            End Set
        End Property

        ' Using a DependencyProperty as the backing store for MaxSwipeTime in milliseconds.  Me enables animation, styling, binding, etc...
        Public Shared ReadOnly MaxSwipeTimeProperty As DependencyProperty =
            DependencyProperty.Register("MaxSwipeTime",
                                        GetType(Integer),
                                        GetType(MagneticSlide),
                                        New UIPropertyMetadata(300))

        Public Property MaxSwipeTime As Integer
            Get
                Return CType(GetValue(MaxSwipeTimeProperty), Integer)
            End Get
            Set(value As Integer)
                SetValue(MaxSwipeTimeProperty, value)
            End Set
        End Property
    End Class
End Namespace