﻿Imports System.Windows
Imports Beginning.Kinect.Framework.Input

Namespace Controls
    Public Class PushButton
        Inherits MagnetButton
        Protected _handDepth As Double

        Public Property PushThreshold As Double
            Get
                Return CType(GetValue(PushThresholdProperty), Double)
            End Get
            Set(value As Double)
                SetValue(PushThresholdProperty, value)
            End Set
        End Property

        ' Using a DependencyProperty as the backing store for Pushthreshold.  Me enables animation, styling, binding, etc...
        Public Shared ReadOnly PushThresholdProperty As DependencyProperty =
            DependencyProperty.Register("PushThreshold",
                                        GetType(Double),
                                        GetType(PushButton),
                                        New UIPropertyMetadata(100.0R))


        Protected Overrides Sub OnKinectCursorMove(sender As Object, e As KinectCursorEventArgs)
            If (e.Z < _handDepth - PushThreshold) Then
                Dim a As New System.Windows.RoutedEventArgs(ClickEvent)

                MyBase.RaiseEvent(New System.Windows.RoutedEventArgs(ClickEvent))
            End If
        End Sub

        Protected Overrides Sub OnKinectCursorEnter(sender As Object, e As KinectCursorEventArgs)
            _handDepth = e.Z
        End Sub

    End Class
End Namespace