﻿Imports System.Windows

Public Class KinectCursorEventArgs
    Inherits RoutedEventArgs

    ''' <summary>
    ''' Initializes a new instance of the <see cref="KinectCursorEventArgs"/> class.
    ''' </summary>
    ''' <param name="x">The X coordinate.</param>
    ''' <param name="y">The Y coordinate.</param>
    Public Sub New(x As Double, y As Double)
        Me.X = x
        Me.Y = y
    End Sub

    ''' <summary>
    ''' Initializes a new instance of the <see cref="KinectCursorEventArgs"/> class.
    ''' </summary>
    ''' <param name="_point">The position as a Point.</param>
    Public Sub New(_point As Point)
        Me.X = _point.X
        Me.Y = _point.Y
    End Sub

    ''' <summary>
    ''' Initializes a new instance of the <see cref="KinectCursorEventArgs"/> class.
    ''' </summary>
    ''' <param name="_routedEvent">The routed event identifier for Me instance of the <see cref="T:System.Windows.RoutedEventArgs"/> class.</param>
    Public Sub New(_routedEvent As RoutedEvent)
        MyBase.New(_routedEvent)
    End Sub

    ''' <summary>
    ''' Initializes a new instance of the <see cref="KinectCursorEventArgs"/> class.
    ''' </summary>
    ''' <param name="_routedEvent">The routed event identifier for Me instance of the <see cref="T:System.Windows.RoutedEventArgs"/> class.</param>
    ''' <param name="x">The X coordinate.</param>
    ''' <param name="y">The Y coordinate.</param>
    ''' <param name="z">The Z distance in millimeters.</param>
    Public Sub New(_routedEvent As RoutedEvent,
                   x As Double,
                   y As Double,
                   z As Double)
        MyBase.New(_routedEvent)
        Me.X = x
        Me.Y = y
        Me.Z = z
    End Sub


    ''' <summary>
    ''' Initializes a new instance of the <see cref="KinectCursorEventArgs"/> class.
    ''' </summary>
    ''' <param name="_routedEvent">The routed event.</param>
    ''' <param name="_point">The position as a Point.</param>
    Public Sub New(_routedEvent As RoutedEvent,
                   _point As Point)
        MyBase.New(_routedEvent)
        Me.X = _point.X
        Me.Y = _point.Y
    End Sub

    ''' <summary>
    ''' Initializes a new instance of the <see cref="KinectCursorEventArgs"/> class.
    ''' </summary>
    ''' <param name="_routedEvent">The routed event.</param>
    ''' <param name="_point">The position as a Point.</param>
    ''' <param name="z">The Z distance in millimeters.</param>
    Public Sub New(_routedEvent As RoutedEvent,
                   _point As Point,
                   z As Double)
        MyBase.New(_routedEvent)
        Me.X = _point.X
        Me.Y = _point.Y
        Me.Z = z
    End Sub

    ''' <summary>
    ''' Initializes a new instance of the <see cref="KinectCursorEventArgs"/> class.
    ''' </summary>
    ''' <param name="_routedEvent">The routed event identifier for Me instance of the <see cref="T:System.Windows.RoutedEventArgs"/> class.</param>
    ''' <param name="source">An alternate source that will be reported when the event is handled. Me pre-populates the <see cref="P:System.Windows.RoutedEventArgs.Source"/> property.</param>
    Public Sub New(_routedEvent As RoutedEvent,
                   source As Object)
        MyBase.New(_routedEvent, source)
    End Sub

    ''' <summary>
    ''' Initializes a new instance of the <see cref="KinectCursorEventArgs"/> class.
    ''' </summary>
    ''' <param name="_routedEvent">The routed event identifier for Me instance of the <see cref="T:System.Windows.RoutedEventArgs"/> class.</param>
    ''' <param name="source">An alternate source that will be reported when the event is handled. Me pre-populates the <see cref="P:System.Windows.RoutedEventArgs.Source"/> property.</param>
    ''' <param name="x">The X coordinate.</param>
    ''' <param name="y">The Y coordinate.</param>
    ''' <param name="z">The Z distance in millimeters.</param>
    Public Sub New(_routedEvent As RoutedEvent,
                   source As Object,
                   x As Double,
                   y As Double,
                   z As Double)
        MyBase.New(_routedEvent, source)
        Me.X = x
        Me.Y = y
        Me.Z = z
    End Sub

    ''' <summary>
    ''' Initializes a new instance of the <see cref="KinectCursorEventArgs"/> class.
    ''' </summary>
    ''' <param name="_routedEvent">The routed event identifier for Me instance of the <see cref="T:System.Windows.RoutedEventArgs"/> class.</param>
    ''' <param name="source">An alternate source that will be reported when the event is handled. Me pre-populates the <see cref="P:System.Windows.RoutedEventArgs.Source"/> property.</param>
    ''' <param name="_point">The position as a Point.</param>
    Public Sub New(_routedEvent As RoutedEvent,
                   source As Object,
                   _point As Point)
        MyBase.New(_routedEvent, source)
        Me.X = _point.X
        Me.Y = _point.Y
    End Sub

    ''' <summary>
    ''' Initializes a new instance of the <see cref="KinectCursorEventArgs"/> class.
    ''' </summary>
    ''' <param name="_routedEvent">The routed event identifier for Me instance of the <see cref="T:System.Windows.RoutedEventArgs"/> class.</param>
    ''' <param name="source">An alternate source that will be reported when the event is handled. Me pre-populates the <see cref="P:System.Windows.RoutedEventArgs.Source"/> property.</param>
    ''' <param name="_point">The position as a Point.</param>
    ''' ''' <param name="z">The Z distance in millimeters.</param>
    Public Sub New(_routedEvent As RoutedEvent,
                   source As Object,
                   _point As Point,
                   z As Double)
        MyBase.New(_routedEvent, source)
        Me.X = _point.X
        Me.Y = _point.Y
        Me.Z = z
    End Sub

    ''' <summary>
    ''' Gets or sets the X coordinate.
    ''' </summary>
    ''' <value>
    ''' The X.
    ''' </value>
    Public Property X As Double

    ''' <summary>
    ''' Gets or sets the Y coordinate.
    ''' </summary>
    ''' <value>
    ''' The Y.
    ''' </value>
    Public Property Y As Double

    ''' <summary>
    ''' Gets or sets the Z value in millimeters.
    ''' </summary>
    ''' <value>
    ''' The Z.
    ''' </value>
    Public Property Z As Double

    ''' <summary>
    ''' Gets or sets the cursor.
    ''' </summary>
    ''' <value>
    ''' The cursor.
    ''' </value>
    Public Property Cursor As CursorAdorner
End Class
