﻿Imports System
Imports System.Linq
Imports System.Windows
Imports System.Windows.Media
Imports Beginning.Kinect.Framework.Controls
Imports Microsoft.Kinect
Imports KinectFrameworkTest.WaveDetection

''' <summary>
''' Interaction logic for MainWindow.xaml
''' </summary>
Class MainWindow
    Private _kinectDevice As KinectSensor
    Private _FrameSkeletons() As Skeleton
    Private _WaveGesture As WaveGesture

    Public Sub New()

        ' この呼び出しはデザイナーで必要です。
        InitializeComponent()

        ' InitializeComponent() 呼び出しの後で初期化を追加します。
        Me._WaveGesture = New WaveGesture()
        AddHandler Me._WaveGesture.GestureDetected, New EventHandler(AddressOf _WaveGesture_GestureDetected)
        Me._kinectDevice = KinectSensor.KinectSensors.FirstOrDefault(Function(x)
                                                                         Return x.Status = KinectStatus.Connected
                                                                     End Function)
        AddHandler Me._kinectDevice.SkeletonFrameReady, AddressOf KinectDevice_SkeletonFrameReady
    End Sub

    Private Sub Button_Click(sender As Object, e As RoutedEventArgs)
        Dim button As KinectButton = CType(sender, KinectButton)
        button.Background = New SolidColorBrush(Colors.Green)
    End Sub

    Private Sub Button_KinectCursorLeave(sender As Object, e As Beginning.Kinect.Framework.Input.KinectCursorEventArgs)
        Dim button As KinectButton = CType(sender, KinectButton)
        button.Background = New SolidColorBrush(Colors.Red)
    End Sub

    Private Sub KinectDevice_SkeletonFrameReady(sender As Object, e As SkeletonFrameReadyEventArgs)
        Using frame As SkeletonFrame = e.OpenSkeletonFrame()
            If (frame IsNot Nothing) Then
                ReDim Me._FrameSkeletons(_kinectDevice.SkeletonStream.FrameSkeletonArrayLength - 1)
                frame.CopySkeletonDataTo(Me._FrameSkeletons)

                Dim startMarker As DateTime = DateTime.Now
                Me._WaveGesture.Update(Me._FrameSkeletons, frame.Timestamp)
            End If
        End Using
    End Sub

    Private Sub _WaveGesture_GestureDetected(sender As Object, e As EventArgs)
        listBox1.Items.Add(String.Format("Wave Detected {0}", DateTime.Now.ToLongTimeString()))
    End Sub
End Class
