﻿Imports System.Windows
Imports System.Windows.Media
Imports System.Windows.Media.Imaging
Imports Microsoft.Kinect
Imports ProximityCamera.ImageManipulationExtensionMethods

''' <summary>
''' Interaction logic for MainWindow.xaml
''' </summary>
Class MainWindow
    Private _kinectSensor As KinectSensor
    Private _isTracking As Boolean = False


    Private _videoFrameImage As WriteableBitmap
    Private _videoFrameImageRect As Int32Rect

    Public Sub New()

        ' この呼び出しはデザイナーで必要です。
        InitializeComponent()

        ' InitializeComponent() 呼び出しの後で初期化を追加します。
        AddHandler Me.Unloaded, Sub()
                                    _kinectSensor.ColorStream.Disable()
                                    _kinectSensor.DepthStream.Disable()
                                End Sub

        AddHandler Me.Loaded, Sub()
                                  _kinectSensor = KinectSensor.KinectSensors(0)

                                  AddHandler _kinectSensor.ColorFrameReady, AddressOf ColorFrameReady
                                  AddHandler _kinectSensor.DepthFrameReady, AddressOf DepthFrameReady
                                  _kinectSensor.ColorStream.Enable()
                                  _kinectSensor.DepthStream.Enable()

                                  _videoFrameImage = New WriteableBitmap(640,
                                                                         480,
                                                                         96,
                                                                         96,
                                                                         PixelFormats.Bgr32,
                                                                         Nothing)
                                  _videoFrameImageRect = New Int32Rect(0, 0, 640, 480)
                                  _kinectSensor.Start()
                              End Sub
    End Sub

    Sub DepthFrameReady(sender As Object, e As DepthImageFrameReadyEventArgs)
        Dim isInRange As Integer = False
        Using imageData As DepthImageFrame = e.OpenDepthImageFrame()
            If (imageData Is Nothing OrElse imageData.PixelDataLength = 0) Then
                Exit Sub
            End If
            Dim bits(imageData.PixelDataLength - 1) As Short
            imageData.CopyPixelDataTo(bits)
            Const minThreshold As Integer = 1000
            Const maxThreshold As Integer = 1200

            For i As Integer = 0 To bits.Length - 1
                Dim depth As Integer = bits(i) >> DepthImageFrame.PlayerIndexBitmaskWidth

                If (depth > minThreshold AndAlso depth < maxThreshold) Then
                    isInRange = True
                    OnDetection()
                    Exit For
                End If
            Next
        End Using

        If (Not isInRange) Then
            OnDetectionStopped()
        End If
    End Sub

    Private Sub OnDetection()
        If (Not _isTracking) Then
            _isTracking = True
        End If
    End Sub

    Private Sub OnDetectionStopped()
        _isTracking = False
    End Sub

    Sub ColorFrameReady(sender As Object, e As ColorImageFrameReadyEventArgs)
        If (_isTracking) Then
            Using frame As ColorImageFrame = e.OpenColorImageFrame()
                If (frame IsNot Nothing) Then
                    rgbImage.Source = frame.ToBitmapSource()
                End If
            End Using
        Else
            rgbImage.Source = Nothing
        End If
    End Sub
End Class
