﻿Imports System.Drawing
Imports Microsoft.Kinect
Imports Emgu.CV

Namespace ImageManipulationExtensionMethods
    Public Module EmguImageExtensions
        <Runtime.CompilerServices.Extension()> _
        Public Function ToOpenCVImage(Of TColor As {Structure, IColor},
                                          TDepth As New)(image As ColorImageFrame) As Image(Of TColor, TDepth)
            Dim _bitmap As Bitmap = image.ToBitmap
            Return New Image(Of TColor, TDepth)(_bitmap)
        End Function

        Public Function ToOpenCVImage(Of TColor As {Structure, IColor},
                                          TDepth As New)(_bitmap As Bitmap) As Image(Of TColor, TDepth)
            Return New Image(Of TColor, TDepth)(_bitmap)
        End Function

        <Runtime.CompilerServices.Extension()> _
        Public Function ToBitmapSource(image As IImage) As System.Windows.Media.Imaging.BitmapSource
            Dim source As BitmapSource = image.Bitmap.ToBitmapSource()
            Return source
        End Function
    End Module
End Namespace

