﻿Imports System
Imports System.Windows
Imports System.Windows.Threading
Imports ProximityCamera.ImageManipulationExtensionMethods
Imports Microsoft.Kinect

''' <summary>
''' Interaction logic for MainWindow.xaml
''' </summary>
Class MainWindow
    Private _kinectSensor As Microsoft.Kinect.KinectSensor
    Private _isTracking As Boolean = False

    Const _threshold As Integer = 100
    Private _lastSkeletonTrackTime As DateTime
    Private _timer As New DispatcherTimer()

    Public Sub New()

        ' この呼び出しはデザイナーで必要です。
        InitializeComponent()

        ' InitializeComponent() 呼び出しの後で初期化を追加します。
        AddHandler Me.Unloaded, Sub()
                                    _kinectSensor.ColorStream.Disable()
                                    _kinectSensor.SkeletonStream.Disable()
                                End Sub

        AddHandler Me.Loaded, Sub()
                                  _kinectSensor = Microsoft.Kinect.KinectSensor.KinectSensors(0)
                                  AddHandler _kinectSensor.ColorFrameReady, AddressOf ColorFrameReady
                                  _kinectSensor.ColorStream.Enable()

                                  AddHandler _kinectSensor.SkeletonFrameReady, AddressOf Pulse
                                  _kinectSensor.SkeletonStream.Enable()
                                  _timer.Interval = New TimeSpan(0, 0, 1)
                                  AddHandler _timer.Tick, New EventHandler(AddressOf _timer_Tick)

                                  _kinectSensor.Start()
                              End Sub
    End Sub
    Sub ColorFrameReady(sender As Object, e As ColorImageFrameReadyEventArgs)
        If (_isTracking) Then
            Using frame As ColorImageFrame = e.OpenColorImageFrame()
                If (frame IsNot Nothing) Then
                    rgbImage.Source = frame.ToBitmapSource()
                End If
            End Using
        Else
            rgbImage.Source = Nothing
        End If
    End Sub

    Private Sub OnDetection()
        If (Not _isTracking) Then
            _isTracking = True
        End If
    End Sub

    Private Sub OnDetectionStopped()
        _isTracking = False
    End Sub


#Region "player detection"

    Sub _timer_Tick(sender As Object, e As EventArgs)
        If (DateTime.Now.Subtract(_lastSkeletonTrackTime).TotalMilliseconds > _threshold) Then
            _timer.Stop()
            OnDetectionStopped()
        End If
    End Sub

    Private Sub Pulse(sender As Object, e As SkeletonFrameReadyEventArgs)
        Using frame As SkeletonFrame = e.OpenSkeletonFrame()
            If (frame Is Nothing OrElse frame.SkeletonArrayLength = 0) Then
                Exit Sub
            End If

            Dim skeletons(frame.SkeletonArrayLength - 1) As Skeleton
            frame.CopySkeletonDataTo(skeletons)

            For s As Integer = 0 To skeletons.Length - 1
                If (skeletons(s).TrackingState = SkeletonTrackingState.Tracked) Then
                    OnDetection()
                    _lastSkeletonTrackTime = DateTime.Now
                    If (Not _timer.IsEnabled) Then
                        _timer.Start()
                    End If
                    Exit For
                End If
            Next
        End Using
    End Sub
#End Region

End Class
