//-------------------------------------------------------------------------------------------------
// File : imguiPS.hlsl
// Desc : Pixel Shader For ImGui.
// Copyright(c) Project Asura. All right reserved.
//-------------------------------------------------------------------------------------------------

///////////////////////////////////////////////////////////////////////////////////////////////////
// VSOutput sturcture
///////////////////////////////////////////////////////////////////////////////////////////////////
struct VSOutput
{
    float4 Position : SV_POSITION;      //!< 位置座標
    float4 Color    : COLOR;            //!< カラー
    float2 TexCoord : TEXCOORD;         //!< テクスチャ座標.
};

///////////////////////////////////////////////////////////////////////////////////////////////////
// PSOutput sturcture
///////////////////////////////////////////////////////////////////////////////////////////////////
struct PSOutput
{
    float4 Target0  : SV_TARGET0;       //!< レンダーターゲット0.
};

//=================================================================================================
// Samplers and Textures.
//=================================================================================================
sampler   ColorSmp : register(s0);      //!< カラーサンプラー.
Texture2D ColorMap : register(t0);      //!< カラーテクスチャ.


//-------------------------------------------------------------------------------------------------
//      ピクセルシェーダメインエントリーポイントです.
//-------------------------------------------------------------------------------------------------
PSOutput main(VSOutput input)
{
    PSOutput output = (PSOutput)0;

    output.Target0 = input.Color * ColorMap.Sample(ColorSmp, input.TexCoord);

    return output;
}
