//-------------------------------------------------------------------------------------------------
// File : imguiVS.hlsl
// Desc : Vertex Shader For ImGui
// Copyright(c) Project Asura. All right reserved.
//-------------------------------------------------------------------------------------------------

///////////////////////////////////////////////////////////////////////////////////////////////////
// VSInput structure
///////////////////////////////////////////////////////////////////////////////////////////////////
struct VSInput
{
    float2 Position : POSITION;     //!< 位置座標.
    float2 TexCoord : TEXCOORD;     //!< テクスチャ座標.
    float4 Color    : COLOR;        //!< カラー.    
};

///////////////////////////////////////////////////////////////////////////////////////////////////
// VSOutput structure
///////////////////////////////////////////////////////////////////////////////////////////////////
struct VSOutput
{
    float4 Position : SV_POSITION;  //!< 位置座標.
    float4 Color    : COLOR;        //!< カラー.
    float2 TexCoord : TEXCOORD;     //!< テクスチャ座標.
};

///////////////////////////////////////////////////////////////////////////////////////////////////
// Transform constant buffer
///////////////////////////////////////////////////////////////////////////////////////////////////
cbuffer Transform : register(b0)
{
    float4x4 Proj;      //!< 射影行列.
};

//-------------------------------------------------------------------------------------------------
//      頂点シェーダメインエントリーポイント.
//-------------------------------------------------------------------------------------------------
VSOutput main(VSInput input)
{
    VSOutput output = (VSOutput)0;
    
    output.Position = mul( Proj, float4(input.Position, 0.0f, 1.0f) );
    output.Color    = input.Color;
    output.TexCoord = input.TexCoord;

    return output;
}
