﻿//-------------------------------------------------------------------------------------------------
// File : a3dDescriptor.h
// Desc : Descriptor Module.
// Copyright(c) Project Asura. All right reserved.
//-------------------------------------------------------------------------------------------------
#pragma once


namespace a3d {

//-------------------------------------------------------------------------------------------------
// Forward Declarations.
//-------------------------------------------------------------------------------------------------
template<typename T> class Pool;


///////////////////////////////////////////////////////////////////////////////////////////////////
// Descriptor class
///////////////////////////////////////////////////////////////////////////////////////////////////
class A3D_API Descriptor : public IReference
{
    //=============================================================================================
    // list of friend classes and methods.
    //=============================================================================================
    friend class DescriptorHeap;
    friend class Pool<Descriptor>;

public:
    //=============================================================================================
    // public variables.
    //=============================================================================================
    /* NOTHING */

    //=============================================================================================
    // public methods.
    //=============================================================================================

    //---------------------------------------------------------------------------------------------
    //! @brief      参照カウントを増やします.
    //---------------------------------------------------------------------------------------------
    void A3D_APIENTRY AddRef() override;

    //---------------------------------------------------------------------------------------------
    //! @brief      解放処理を行います.
    //---------------------------------------------------------------------------------------------
    void A3D_APIENTRY Release() override;

    //---------------------------------------------------------------------------------------------
    //! @brief      参照カウントを取得します.
    //---------------------------------------------------------------------------------------------
    uint32_t A3D_APIENTRY GetCount() const override;

    //---------------------------------------------------------------------------------------------
    //! @brief      CPUディスクリプタハンドルを取得します.
    //---------------------------------------------------------------------------------------------
    D3D12_CPU_DESCRIPTOR_HANDLE A3D_APIENTRY GetHandleCPU() const;

    //---------------------------------------------------------------------------------------------
    //! @brief      GPUディスクリプタハンドルを取得します.
    //---------------------------------------------------------------------------------------------
    D3D12_GPU_DESCRIPTOR_HANDLE A3D_APIENTRY GetHandleGPU() const;

private:
    //=============================================================================================
    // private variables.
    //============================================================================================= 
    DescriptorHeap*             m_pHeap;        //!< ヒープへのポインタです.
    D3D12_CPU_DESCRIPTOR_HANDLE m_HandleCPU;    //!< CPUディスクリプタハンドルです.
    D3D12_GPU_DESCRIPTOR_HANDLE m_HandleGPU;    //!< GPUディスクリプタハンドルです.
    std::atomic<uint32_t>       m_RefCount;     //!< 参照カウンタです.

    //=============================================================================================
    // private methods.
    //=============================================================================================

    //---------------------------------------------------------------------------------------------
    //! @brief      コンストラクタです.
    //---------------------------------------------------------------------------------------------
    A3D_APIENTRY Descriptor();

    //---------------------------------------------------------------------------------------------
    //! @brief      デストラクタです.
    //---------------------------------------------------------------------------------------------
    A3D_APIENTRY ~Descriptor();

    Descriptor      (const Descriptor&) = delete;
    void operator = (const Descriptor&) = delete;
};


} // namespace a3d
