//-------------------------------------------------------------------------------------------------
// File : a3dBuffer.h
// Desc : Buffer Module.
// Copyright(c) Project Asura. All right reserved.
//-------------------------------------------------------------------------------------------------
#pragma once


namespace a3d {

///////////////////////////////////////////////////////////////////////////////////////////////////
// Buffer class
///////////////////////////////////////////////////////////////////////////////////////////////////
class A3D_API Buffer : public IBuffer, public BaseAllocator
{
    //=============================================================================================
    // list of friend classes and methods.
    //=============================================================================================
    /* NOHTING */

public:
    //=============================================================================================
    // public variables.
    //=============================================================================================
    /* NOTHING */

    //=============================================================================================
    // public methods.
    //=============================================================================================

    //---------------------------------------------------------------------------------------------
    //! @brief      s܂.
    //!
    //! @param[in]      pDevice         foCXł.
    //! @param[in]      pDesc           \ݒł.
    //! @param[out]     ppResource      \[X̊i[ł.
    //! @retval true    ɐ.
    //! @retval false   Ɏs.
    //---------------------------------------------------------------------------------------------
    static bool A3D_APIENTRY Create(
        IDevice*            pDevice,
        const BufferDesc*   pDesc,
        IBuffer**           ppResource);

    //---------------------------------------------------------------------------------------------
    //! @brief      QƃJEg𑝂₵܂.
    //---------------------------------------------------------------------------------------------
    void A3D_APIENTRY AddRef() override;

    //---------------------------------------------------------------------------------------------
    //! @brief      s܂.
    //---------------------------------------------------------------------------------------------
    void A3D_APIENTRY Release() override;

    //---------------------------------------------------------------------------------------------
    //! @brief      QƃJEg擾܂.
    //!
    //! @return     QƃJEgԋp܂.
    //---------------------------------------------------------------------------------------------
    uint32_t A3D_APIENTRY GetCount() const override;

    //---------------------------------------------------------------------------------------------
    //! @brief      foCX擾܂.
    //!
    //! @param[out]     ppDevice        foCX̊i[ł.
    //---------------------------------------------------------------------------------------------
    void A3D_APIENTRY GetDevice(IDevice** ppDevice) override;

    //---------------------------------------------------------------------------------------------
    //! @brief      \ݒ擾܂.
    //!
    //! @return     \ݒԋp܂.
    //---------------------------------------------------------------------------------------------
    BufferDesc A3D_APIENTRY GetDesc() const override;

    //---------------------------------------------------------------------------------------------
    //! @brief      }bsOs܂.
    //!
    //! @return     }bsOł.
    //---------------------------------------------------------------------------------------------
    void* A3D_APIENTRY Map() override;

    //---------------------------------------------------------------------------------------------
    //! @brief      }bsO܂.
    //---------------------------------------------------------------------------------------------
    void A3D_APIENTRY Unmap() override;

    //---------------------------------------------------------------------------------------------
    //! @brief      obt@擾܂.
    //!
    //! @return     obt@ԋp܂.
    //---------------------------------------------------------------------------------------------
    VkBuffer A3D_APIENTRY GetVulkanBuffer() const;

    //---------------------------------------------------------------------------------------------
    //! @brief      foCX擾܂.
    //!
    //! @return     foCXԋp܂.
    //---------------------------------------------------------------------------------------------
    VkDeviceMemory A3D_APIENTRY GetVulkanDeviceMemory() const;

    //---------------------------------------------------------------------------------------------
    //! @brief      v擾܂.
    //!
    //! @return     vԋp܂.
    //---------------------------------------------------------------------------------------------
    VkMemoryRequirements A3D_APIENTRY GetVulkanMemoryRequirements() const;

    //---------------------------------------------------------------------------------------------
    //! @brief      \[X^Cv擾܂.
    //!
    //! @return     \[X^Cvԋp܂.
    //---------------------------------------------------------------------------------------------
    RESOURCE_KIND A3D_APIENTRY GetKind() const override;

private:
    //=============================================================================================
    // private variables.
    //=============================================================================================
    std::atomic<uint32_t>   m_RefCount;             //!< QƃJE^ł.
    Device*                 m_pDevice;              //!< foCXł.
    BufferDesc              m_Desc;                 //!< \ݒł.
    VkBuffer                m_Buffer;               //!< obt@ł.
    VkDeviceMemory          m_DeviceMemory;         //!< foCXł.
    VkMemoryRequirements    m_MemoryRequirements;   //!< vł.

    //=============================================================================================
    // private methods.
    //=============================================================================================

    //---------------------------------------------------------------------------------------------
    //! @brief      RXgN^ł.
    //---------------------------------------------------------------------------------------------
    A3D_APIENTRY Buffer();

    //---------------------------------------------------------------------------------------------
    //! @brief      fXgN^ł.
    //---------------------------------------------------------------------------------------------
    A3D_APIENTRY ~Buffer();

    //---------------------------------------------------------------------------------------------
    //! @brief      s܂.
    //!
    //! @param[in]      pDevice     foCXł.
    //! @param[in]      pDesc       \ݒł.
    //! @retval true    ɐ.
    //! @retval false   Ɏs.
    //---------------------------------------------------------------------------------------------
    bool A3D_APIENTRY Init(IDevice* pDevice, const BufferDesc* pDesc);

    //---------------------------------------------------------------------------------------------
    //! @brief      Is܂.
    //---------------------------------------------------------------------------------------------
    void A3D_APIENTRY Term();

    Buffer          (const Buffer&) = delete;
    void operator = (const Buffer&) = delete;
};


} // namespace a3d
