﻿//-------------------------------------------------------------------------------------------------
// File : hidKeyboard.h
// Desc : Keyboard State.
// Copyright(c) Project Asura. All right reserved.
//-------------------------------------------------------------------------------------------------
#pragma once

//-------------------------------------------------------------------------------------------------
// Includes
//-------------------------------------------------------------------------------------------------
#include <hid.h>


namespace hid {

///////////////////////////////////////////////////////////////////////////////////////////////////
// KeyboardState class
///////////////////////////////////////////////////////////////////////////////////////////////////
class KeyboardState : IKeyboardState
{
    //=============================================================================================
    // list of friend classes and methods.
    //=============================================================================================
    /* NOTHING */

public:
    //=============================================================================================
    // public variables.
    //=============================================================================================
    static const uint32_t MaxKeys = 256;
    bool        m_Keys[2][MaxKeys];
    uint32_t    m_BuffferIndex;

    //=============================================================================================
    // public methods.
    //=============================================================================================
    KeyboardState()
    : m_BuffferIndex(0)
    {
        for(auto i=0u; i<MaxKeys; ++i)
        {
            m_Keys[0][i] = false;
            m_Keys[1][i] = false;
        }
    }

    ~KeyboardState()
    { /* DO_NOTHING */ }

    bool IsPush(uint32_t value) const override
    { return m_Keys[m_BuffferIndex][value]; }

    bool IsDown(uint32_t value) const override
    { return m_Keys[m_BuffferIndex][value] & (!m_Keys[1 - m_BuffferIndex][value]); }
};

} // namespace hid

