package say.wiiremote.sample;
import say.wiiremote.WiiRemote;

public class ButtonStateViewer
{
	private boolean done = false;
	private WiiRemote[] wiiRemotes;
	
	public void init() throws Exception
	{
		// open all Wii Remote devices
		this.wiiRemotes = WiiRemote.getWiiRemotes();
		for (int i = 0;i < this.wiiRemotes.length;i++)
		{
			wiiRemotes[i].open();
		}

	}

	public void mainLoop() throws Exception 
	{
		done = false;
		while (!done)
		{
			int updated_index;
			
			while ((updated_index = WiiRemote.poll()) >= 0)
			{
				WiiRemote wiiRemote = wiiRemotes[updated_index];
				int buttons = wiiRemote.getState(WiiRemote.DATA_BUTTONS);
				System.out.println("[" + updated_index + "]" +
					", 2:" + WiiRemote.checkButtonAny(buttons, WiiRemote.MASK_BUTTON_TWO)+
					", 1:" + WiiRemote.checkButtonAny(buttons, WiiRemote.MASK_BUTTON_ONE) +
					", B:" + WiiRemote.checkButtonAny(buttons, WiiRemote.MASK_BUTTON_B) +
					", A:" + WiiRemote.checkButtonAny(buttons, WiiRemote.MASK_BUTTON_A) +
					", -:" + WiiRemote.checkButtonAny(buttons, WiiRemote.MASK_BUTTON_MINUS) +
					", H:" + WiiRemote.checkButtonAny(buttons, WiiRemote.MASK_BUTTON_HOME) +
					", L:" + WiiRemote.checkButtonAny(buttons, WiiRemote.MASK_BUTTON_LEFT) +
					", R:" + WiiRemote.checkButtonAny(buttons, WiiRemote.MASK_BUTTON_RIGHT) +
					", D:" + WiiRemote.checkButtonAny(buttons, WiiRemote.MASK_BUTTON_DOWN) +
					", U:" + WiiRemote.checkButtonAny(buttons, WiiRemote.MASK_BUTTON_UP) +
					", +:" + WiiRemote.checkButtonAny(buttons, WiiRemote.MASK_BUTTON_PLUS)  
					);
				if (WiiRemote.checkButtonAll(buttons, "AB"))
				{
					done = true;
					break;
				}
			}

			try
			{
				Thread.sleep(30);
			}
			catch (InterruptedException ie)
			{
				done = true;
			}
		}
	}

	public void quit() throws Exception
	{
		for (int i = 0;i < this.wiiRemotes.length;i++)
		{
			wiiRemotes[i].close();
		}
	}

	public static void main(String[] args)
	{
		try
		{
			WiiRemote.init();
			if (WiiRemote.getNumWiiRemote()== 0)
			{
				System.out.println("WiiRemote Not Found");
				System.exit(0);
			}

			try
			{
				ButtonStateViewer viewer = new ButtonStateViewer();
				viewer.init();
				viewer.mainLoop();
				viewer.quit();
			}
			finally
			{
				WiiRemote.quit();
			}
		}
		catch (Exception e)
		{
			e.printStackTrace();
		}
	}
}
