#!/bin/bash
# _/_/_/_/ _/_/_/_/ _/_/_/_/ _/_/_/_/ _/_/_/_/ _/_/_/_/ _/_/_/_/ _/_/_/_/
# Name          : heartbeat_logmoni.sh
# Description   : heartbeat ロギングデーモンのプロセス監視を行う
# Author        : 2006.10.19 h.yamauchi
# Editor        : 2007.02.09 t.fukada
# Editor        : 2007.03.01 m.takeuchi
# Source        : /etc/ha.d/monitoring/heartbeat_logmoni.sh
# OS  Version   : RHEL ES4 Update4
# HB2 Version   : 2.0.8.p1
#
# License: GNU General Public License (GPL)
# Copyright (c) 2008 NIPPON TELEGRAPH AND TELEPHONE CORPORATION
# _/_/_/_/ _/_/_/_/ _/_/_/_/ _/_/_/_/ _/_/_/_/ _/_/_/_/ _/_/_/_/ _/_/_/_/

HBBN_DIR=/usr/lib/heartbeat
RUNDIR=/var/run

# サービス操作情况ファイル
SERVICE_STATE=${RUNDIR}/heartbeat/start_stop_state

# 監視するHeartbeat LoggingDaemonプロセス
MONITORING_LOGD=("ha_logd: read process" "ha_logd: write process")

# Heartbeatロギングデーモンモニタ プロセス
KILLING_SELF_PROCESS=(heartbeat_logmoni.sh)

# ロギングデーモン監視開始待ち時間(Default:30)
MON_LOGD_START_WAIT_TIME=30

# ロギングデーモン監視間隔(Default:60)
MON_LOGD_MONITORING_WAIT_TIME=30

# ロギングデーモン監視ログファイル
MON_LOGD_MONITORING_HBLOG=/var/log/heartbeat_process_monitor.log

# for ocf_log
#. /usr/lib64/heartbeat/ocf-shellfuncs
#HALOG_FILE=/var/log/ha-log

# ログメッセージ
LPPID="Heartbeat Logging Daemon Monitor($$)"
INF="INFO"
ERR="ERROR"
WAN="WARNING"
ILOG001="${INF}: monitoring [start]"
ILOG002="${INF}: monitoring [beginning waiting]"
ILOG003="${INF}: monitoring [end]"
ILOG004="${INF}: system reboot now"
ILOG005="${INF}: monitoring [process is alive]"
ELOG001="${ERR}: target monitor logd is down -- "
WLOG001="${WAN}: killing heartbeat logd -- "
WLOG002="${WAN}: monitoring [logd is restart]"

#
# ロギング
#
logging(){
    echo `date` ${LPPID} ${1} >> ${MON_LOGD_MONITORING_HBLOG}

    # for ocf_log
    #ocf_log debug ${LPPID} ${1} >> ${HALOG_FILE} 2>&1
}

#
# モニタ初期化
#
logd_monitor_start(){

    #
    # 開始時にこのスクリプトが既に実行中の場合は停止する
    #
    for KILL_SELF_PROC in "${KILLING_SELF_PROCESS[@]}"
    do
        ps -ef | grep "${KILL_SELF_PROC}" | grep -v grep | \
          awk -v PID=$$ '$2!=PID {print $2}' | xargs kill -9 > /dev/null 2>&1
    done

    #
    # heartbeatからのシグナルを拒否
    #
    trap '' 1 2 3 15

    #
    logging "${ILOG002} ${MON_LOGD_START_WAIT_TIME}sec"
    sleep $MON_LOGD_START_WAIT_TIME
}

#
# モニタリング対象プロセスの生存確認
#
isalive_logd(){

    # モニタリング対象プロセスの生存を確認する
    ISALIVE_FLG=1

    for MON_LOGD in "${MONITORING_LOGD[@]}"
    do
        pgrep -fl "${MON_LOGD}" > /dev/null 2>&1
        PRESULT=$?
        if [ ${PRESULT} -ne 0 ]; then
            K_FLG=`cat ${SERVICE_STATE}`
            if [ ${K_FLG} = "start" ]; then
                logging "${ELOG001} ${MON_LOGD}"
            fi
            ISALIVE_FLG=0
            break;
        fi
    done

    return ${ISALIVE_FLG}
}

#
# 全ＨＢロギングデーモンプロセス関連ＫＩＬＬ
#
logd_killall(){

    # HeartBeat ロギングデーモン系のKILL
    for KILL_PROC in "${MONITORING_LOGD[@]}"
    do
        pgrep -fl "${KILL_PROC}" > /dev/null 2>&1
        RESULT=$?
        if [ ${RESULT} -eq 0 ]; then
            KILL_PID=`pgrep -fl "${KILL_PROC}" | awk '{print $1}'`
            logging "${WLOG001} ${KILL_PROC}(pid:${KILL_PID})"
            echo ${KILL_PID} | xargs kill -9 > /dev/null 2>&1
        fi
    done
    echo 0
}

#
# ロギングデーモンのリスタート
#
logd_restart(){
    ${HBBN_DIR}/ha_logd -d >/dev/null 2>&1
    logging "${WLOG002}"
}

#
# モニタリング
#
logd_monitor(){

    logd_monitor_start
    logging "${ILOG001}"

    #
    # Monitoringループ
    #
    while [ 1 ]
    do
        # モニタリング対象プロセスの生存を確認する
        isalive_logd
        ISALIVE_FLG=$?

        if [ $ISALIVE_FLG -eq 0 ]; then

            # モニタリング対象プロセスが存在していない場合
            K_FLG=`cat ${SERVICE_STATE}`
            if [ ${K_FLG} = "start" ]; then

                # HeartBeat ロギングデーモン系のKILL
                logd_killall

                # ロギングデーモンを再起動する
                logd_restart
           fi

        else

            # モニタリング対象プロセスが存在している場合
            logging "${ILOG005}"

        fi

        K_FLG=`cat ${SERVICE_STATE}`
        if [ ${K_FLG} = "stop" ]; then

            # サービスが停止された場合モニタ終了
            break
        fi

        #
        # モニタリング間隔の間、スリープ
        #
        sleep $MON_LOGD_MONITORING_WAIT_TIME
    done

    logging "${ILOG003}"
    exit 0
}

#
# Usage
#
logd_usage(){
    echo "Usage : $KILLING_SELF_PROCESS { monitor | killall } " 1>&2
    return 1
}

#
#
#
case $1 in
    monitor)    logd_monitor
        exit $? ;;
    killall)    logd_killall
        exit $? ;;
    *)          logd_usage
        exit $? ;;
esac
exit 0
