########################################
# Derived definitions
########################################
%define __check_files %{nil}
%define name pm_extras
%define version 2.0
%define release 1%{?dist}
%define prefix /usr
%define libdir	%{_libdir}
# rpmbuild --with ...
%bcond_with upstart
%bcond_with systemd
#
%define ocfdir /usr/lib/ocf/resource.d/heartbeat
%define extdir %{_libdir}/stonith/plugins/external
#
Summary: Extra Tools & Scripts for Pacemaker 
Name: %{name}
Version: %{version}
Release: %{release}
Group: Applications
Source: %{name}-%{version}.tar.gz
License: GPL
Vendor: NIPPON TELEGRAPH AND TELEPHONE CORPORATION
BuildRoot: %{_tmppath}/%{name}-%{version}
BuildRequires: make, pacemaker-libs-devel >= 1.1.0, cluster-glue-libs-devel >= 1.0.6, corosynclib-devel >= 2.0.0
Requires: pacemaker >= 1.1.0, resource-agents >= 1.0.3, cluster-glue >= 1.0.6

########################################
%description
Extra Scripts for pacemaker and resource-agents and cluster-glue.

%prep
rm -rf $RPM_BUILD_ROOT
%setup -q

%build
%{configure} \
%{?with_upstart:--enable-upstart} \
%{?with_systemd:--enable-systemd}

%pre

%install
make DESTDIR=$RPM_BUILD_ROOT install

%clean
if
	[ -n "${RPM_BUILD_ROOT}"  -a "${RPM_BUILD_ROOT}" != "/" ]
then
	rm -rf $RPM_BUILD_ROOT
fi
rm -rf $RPM_BUILD_DIR/%{name}-%{version}

%post

%preun
%if %{with systemd}
%systemd_preun ifcheckd.service
%endif
%if %{with upstart}
/sbin/initctl stop ifcheckd > /dev/null 2>&1 || :
%endif

%postun

%files
%defattr(-,root,root)

%dir %{ocfdir}
%attr (755, root, root) %{ocfdir}/NVclient
%attr (755, root, root) %{ocfdir}/VIPcheck
%attr (755, root, root) %{ocfdir}/hulft

%dir %{extdir}
%attr (755, root, root) %{extdir}/stonith-helper

%attr (-,root,root) %{_sbindir}/ifcheckd

%{?with_upstart:%attr (644, root, root) %{_sysconfdir}/init/ifcheckd.conf}

%{?with_systemd:%attr (644, root, root) %{_unitdir}/ifcheckd.service}

%doc %{_docdir}/pm_extras/README
%doc %{_docdir}/pm_extras/HowToBuild_pm_extras.txt

%changelog
* Wed Jun 12 2013 Yuichi SEINO <seino.cluster2@gmail.com>
- tool ifcheckd 1.0 for Corosync-2.0
* Fri May 13 2011 Hideo Yamauchi <yamauchi@matrixjpn.com>
* Wed Oct 6 2010 Yuusuke IIDA <iidayuus@intellilink.co.jp>
- initial release
  - RA NVclient 1.4
  - RA VIPcheck 1.1
  - plugin stonith-helper 1.0
  - tool ifcheckd 1.0 for Heartbeat
  - tool iface_check.lcrso 1.0 for Corosync
    - The use is going to be enabled after corosync-2.0.

