<?php
/**
 *  Lism_AppManager.php
 *
 *  @author     {$author}
 *  @package    LISM
 *  @version    $Id: skel.app_manager.php,v 1.2 2006/11/06 14:31:24 cocoitiban Exp $
 */

/**
 *  Lism_AppManager
 *
 *  @author     {$author}
 *  @access     public
 *  @package    LISM
 */
class Lism_AppManager extends Ethna_AppManager
{
    var $user = null;

    var $password = null;

    function getUser()
    {
        return $this->user;
    }

    function getPassword()
    {
        return $this->password;
    }

    /**
     *  ユーザを認証する
     *
     *  @access public
     *  @param  string  $userid     ユーザID
     *  @param  array   $password       パスワード
     *  @return mixed   1:認証成功 0:認証失敗 Ethna_Error:エラー
     */
    function auth($userid, $password, $authtype)
    {
        $conf = $this->config->get('ldap');

        $ldap = ldap_connect($conf['uri']);
        if ($ldap) {
            $sconf = $this->config->get('secioss');
            $filter = array('uid' => $userid);
            if (isset($sconf['system'])) {
                $filter['system'] = 'master';
            }
            if (isset($sconf['loginfilter']) && is_array($sconf['loginfilter'])) {
                foreach ($sconf['loginfilter'] as $key => $value) {
                    $filter[$key] = $value;
                }
            }
            $r = $this->getObjectPropList('user', array('id'), $filter);
            if (Ethna::isError($r)) {
                return Ethna::raiseError("bind failed.", E_DB_CONNECT);
            } else if ($r[0] != 1) {
                return false;
            }

            if ($authtype == 'sso') {
                $suffix = isset($sconf['suffix']) ? $sconf['suffix'] : $sconf['basedn'];
                $binddn = "authzFrom=".$conf['binddn'].","."authzTo=".$r[1][0]['id'].",cn=authz,$suffix";
                $password = $conf['bindpw'];
            } else {
                $binddn = $r[1][0]['id'];
                $r = @ldap_bind($ldap, $binddn, $password);
                if (!$r) {
                    //return Ethna::raiseError("bind failed.", E_DB_CONNECT);
                    return false;
                }
            }
            $this->user = $binddn;
            $this->password = $password;
        } else {
            return Ethna::raiseError("Could not connect to LDAP server.", E_DB_CONNECT);
        }

        return true;
    }

    /**
     *  オブジェクトを追加する
     *
     *  @access public
     *  @param  string  $class      Ethna_AppObjectの継承クラス名
     *  @param  array   $prop       プロパティ一覧
     *  @return mixed   0:正常終了 Ethna_Error:エラー
     */
    function addObject($class, $prop)
    {
        $class_name = sprintf("%s_%s", $this->backend->getAppId(), $class);

        $object =& new $class_name($this->backend, null, null, $prop);

        $r = $object->add();
        if (Ethna::isError($r)) {
          return $r;
        }

        return $object;
    }

    /**
     *  オブジェクトを更新する
     *
     *  @access public
     *  @param  mixed   $key_type   検索キー名
     *  @param  mixed   $key        検索キー
     *  @param  array   $prop       プロパティ一覧
     *  @return mixed   0:正常終了 Ethna_Error:エラー
     */
    function updateObject($class, $key_type, $key, $prop)
    {
        $class_name = sprintf("%s_%s", $this->backend->getAppId(), $class);

        $object =& new $class_name($this->backend, $key_type, $key, $prop);

        if (is_null($key_type) == false && is_null($key) == false) {
            foreach ($prop as $k => $v) {
                $object->set($k, $v);
            }
        }

        $r = $object->update();
        if (Ethna::isError($r)) {
          return $r;
        }

        return $object;
    }

    /**
     *  オブジェクトを削除する
     *
     *  @access public
     *  @param  mixed   $key_type   検索キー名
     *  @param  mixed   $key        検索キー
     *  @return mixed   0:正常終了 Ethna_Error:エラー
     */
    function removeObject($class, $key_type, $key)
    {
        $class_name = sprintf("%s_%s", $this->backend->getAppId(), $class);

        $object =& new $class_name($this->backend, $key_type, $key, null);

        return $object->remove();
    }
}
?>
