<?php
/**
 *  Secioss_User.php
 *
 *  @author     {$author}
 *  @package    Secioss
 *  @version    $Id: skel.app_object.php,v 1.3 2006/11/06 14:31:24 cocoitiban Exp $
 */
require_once 'Mail.php';
require_once 'Secioss_AppObject.php';

define('USER_CSV', '/opt/secioss/var/lib/csv/user.csv');

/**
 *  Secioss_UserManager
 *
 *  @author     {$author}
 *  @access     public
 *  @package    Secioss
 */
class Secioss_UserManager extends Ethna_AppManager
{
}

/**
 *  Secioss_User
 *
 *  @author     {$author}
 *  @access     public
 *  @package    Secioss
 */
class Secioss_User extends Secioss_AppObject
{
    /**
     *  プロパティの表示名を取得する
     *
     *  @access public
     */
    function getName($key)
    {
        return $this->get($key);
    }

    function getLdapPasswd($passwd)
    {
        $conf = $this->config->get('ldap');
        if (isset($conf['pwhash'])) {
            $hash = $conf['pwhash'];
            $tab = '';
            if ($hash == 'CRYPT' || $hash == 'MD5' || $hash == 'SHA') {
                $tab = '{'.$hash.'}';
            }

            $passwd = $tab.Secioss_User::hashPasswd($passwd);
        }

        return $passwd;
    }

    /**
     * パスワード初期化
     *
     * パスワードを初期化する。
     * @access public
     * @param string
     * @return void
     */
    function initPasswd($passwd, $ppolicy = true)
    {
        $conf = $this->config->get('ldap');
        if (isset($conf['pwhash'])) {
            $hash = $conf['pwhash'];
            $tab = '';
            if ($hash == 'CRYPT' || $hash == 'MD5' || $hash == 'SHA') {
                $tab = '{'.$hash.'}';
            }

            $passwd = $tab.$this->hashPasswd($passwd);
        }

        $info = array();
        $info['userpassword'] = $passwd;
        if (in_array('seciossiamaccount', $this->object_def['user']['objectclass'])) {
            $info['seciossencryptedpassword'] = array();
        }

        if (strtoupper(substr(PHP_OS, 0, 3)) === 'WIN') {
            $ldap = $this->connect();
            if (Ethna::isError($ldap)) {
                return $ldap;
            }
            $this->my_ldap = $ldap;
        }
        $r = @ldap_modify($this->my_ldap, $this->id, $info);
        if (!$r) {
            return Ethna::raiseError(ldap_error($this->my_ldap));
        }
        if (strtoupper(substr(PHP_OS, 0, 3)) === 'WIN') {
            $this->disconnect();
        }

        return 0;
    }

    /**
     * パスワードの暗号化
     *
     * パスワードを暗号化する。対応する暗号方式はCRYPT、MD5、SHA。
     * @access private
     * @param string $passwd  パスワード
     * @return string  暗号化されたパスワード
     */
    function hashPasswd($passwd)
    {
        $conf = $this->config->get('ldap');
        if (!isset($conf['pwhash'])) {
            return $passwd;
        }

        $opts = split(':', $conf['pwhash']);
        $htype = $opts[0];
        $otype = isset($opts[1]) ? $opts[1] : '';

        switch($htype) {
          case 'CRYPT':
            $token = array_merge(range('0', '9'), range('a', 'z'), range('A', 'Z'));
            $salt = $token[rand(0, count($token) - 1)].$token[rand(0, count($token) - 1)];
            return crypt($passwd, $salt);
            break;
          case 'MD5':
            $passwd = pack('H*', md5($passwd));
            return $otype == 'hex' ? $passwd : base64_encode($passwd);
            break;
          case 'SHA':
            $passwd = pack('H*', sha1($passwd));
            return $otype == 'hex' ? $passwd : base64_encode($passwd);
            break;
          case 'AD':
            $passwd = "\"".$passwd."\"";
            for ($i = 0; $i < strlen($passwd); $i++) {
               $adpasswd .= "{$passwd{$i}}\000";
            }
            return $adpasswd;
            break; 
          case 'CLEARTEXT':
            return $passwd;
            break;
          default:
            return $passwd;
        }
    }

    /**
     * メール送信
     *
     * 与えられたファイルの内容に対して文字列の変換を行い、それをメールで送信する。
     * @param string  送信先
     * @param array  変換文字列
     * @return boolean
     */
    function sendMail($subject, $from = null, $body, $params) {
        $auth =& $this->backend->getManager('Auth');
        $conf = parse_ini_file(BASEDIR.'/conf/mail/config.ini');
        $patterns = array();
        $replacements = array();
        $mailaddr = $this->get('mail');
        $i = 0;

        if (!$mailaddr) {
            $line = '';
            foreach ($params as $key => $value) {
                $line = "$value,";
            }
            $line = rtrim($line, ",")."\n";
            file_put_contents(BASEDIR.'/log/nomail.log', $line, FILE_APPEND);
            chmod(BASEDIR.'/log/nomail.log', 0600);
            return true;
        }

        preg_match('/^(.+):([0-9]+)$/', $conf['smtp'], $matches);
        $option = array(
            'host' => $matches[1],
            'port' => $matches[2] ? $matches[2] : 25

        );
        $username = isset($conf['smtpauth_user']) ? $conf['smtpauth_user'] : '';
        $password = isset($conf['smtpauth_pass']) ? $auth->decrypt($conf['smtpauth_pass'], '/opt/secioss/etc/auth_tkt.conf') : '';
        if ($username && $password) {
            $option['auth'] = true;
            $option['username'] = $username;
            $option['password'] = $password;
        }

        foreach ($params as $key => $value) {
            $patterns[$i] = '/\${'.$key.'}/';
            $replacements[$i] = $value;
            $i++;
        }
        if (is_array($patterns) && count($patterns)) {
            $body = preg_replace($patterns, $replacements, $body);
        }

        $headers = array(
            'To' => $mailaddr,
            'From' => $from ? $from : $conf['postmaster'],
            'Subject' => mb_encode_mimeheader(mb_convert_encoding($subject, 'ISO-2022-JP', 'auto'), 'ISO-2022-JP')
        );
        $body = mb_convert_encoding($body, 'ISO-2022-JP', 'auto');

        $mail = Mail::factory('smtp', $option);
        return $mail->send($mailaddr, $headers, $body);
    }
}
?>
