<?php
/**
 *  System/Create.php
 *
 *  @author     {$author}
 *  @package    Secioss
 *  @version    $Id: skel.action.php 387 2006-11-06 14:31:24Z cocoitiban $
 */

/**
 *  System_Createフォームの実装
 *
 *  @author     {$author}
 *  @access     public
 *  @package    Secioss
 */
class Secioss_Form_SystemCreate extends Secioss_ActionForm
{
    /** @var    bool    バリデータにプラグインを使うフラグ */
    var $use_validator_plugin = true;

    /**
     *  @access private
     *  @var    array   フォーム値定義
     */
    var $form = array(
        'newid' => array(
            'type'          => VAR_TYPE_STRING,
            'form_type'     => FORM_TYPE_TEXT,
            'name'          => 'ID',
            'required'      => true
        ),
        'newsynctype' => array(
            'type'          => VAR_TYPE_STRING,
            'form_type'     => FORM_TYPE_RADIO,
            'name'          => '同期サーバのタイプ',
            'option'        => 'synctype_select',
            'default'       => 'slave',
            'required'      => true
        ),
        'newldaptype' => array(
            'type'          => VAR_TYPE_STRING,
            'form_type'     => FORM_TYPE_SELECT,
            'name'          => 'LDAPサーバの種類',
            'option'        => 'ldaptype_select '
        ), 
        'newldapuri' => array(
            'type'          => VAR_TYPE_STRING,
            'form_type'     => FORM_TYPE_TEXT,
            'name'          => 'LDAPサーバのURI',
            'required'      => true,
            'regexp'        => '/^ldaps?:\/\/.+/'
        ),
        'newbasedn' => array(
            'type'          => VAR_TYPE_STRING,
            'form_type'     => FORM_TYPE_TEXT,
            'name'          => 'LDAPサーバのベースDN',
            'required'      => true
        ),
        'newbinddn' => array(
            'type'          => VAR_TYPE_STRING,
            'form_type'     => FORM_TYPE_TEXT,
            'name'          => 'LDAPサーバのユーザ名',
            'required'      => true
        ),
        'newbindpw' => array(
            'type'          => VAR_TYPE_STRING,
            'form_type'     => FORM_TYPE_PASSWORD,
            'name'          => 'LDAPサーバのパスワード',
            'required'      => false,
        ),
        'newpwhash' => array(
            'type'          => VAR_TYPE_STRING,
            'form_type'     => FORM_TYPE_SELECT,
            'name'          => 'パスワードハッシュ形式',
            'option'        => array('PLAINTEXT' => 'PLAINTEXT', 'CRYPT' => 'CRYPT', 'MD5' => 'MD5', 'SHA' => 'SHA', 'AD' => 'Active Directory')
        ),
        'dn' => array(
            'type'          => VAR_TYPE_STRING,
            'form_type'     => FORM_TYPE_HIDDEN,
            'name'          => 'ID'
        ),
        'synctype' => array(
            'type'          => VAR_TYPE_STRING,
            'form_type'     => FORM_TYPE_HIDDEN,
            'name'          => '同期サーバのタイプ'
        ),
        'ldaptype' => array(
            'type'          => VAR_TYPE_STRING,
            'form_type'     => FORM_TYPE_HIDDEN,
            'name'          => 'LDAPサーバの種類'
        ),
        'ldapuri' => array(
            'type'          => VAR_TYPE_STRING,
            'form_type'     => FORM_TYPE_TEXT,
            'name'          => 'LDAPサーバのURI',
            'regexp'        => '/^ldaps?:\/\/.+/'
        ),
        'basedn' => array(
            'type'          => VAR_TYPE_STRING,
            'form_type'     => FORM_TYPE_TEXT,
            'name'          => 'LDAPサーバのベースDN',
        ),
        'binddn' => array(
            'type'          => VAR_TYPE_STRING,
            'form_type'     => FORM_TYPE_TEXT,
            'name'          => 'LDAPサーバのユーザ名',
        ),
        'bindpw' => array(
            'type'          => VAR_TYPE_STRING,
            'form_type'     => FORM_TYPE_PASSWORD,
            'name'          => 'LDAPサーバのパスワード',
        ),
        'pwhash' => array(
            'type'          => VAR_TYPE_STRING,
            'form_type'     => FORM_TYPE_SELECT,
            'name'          => 'パスワードハッシュ形式',
            'option'        => array('PLAINTEXT' => 'PLAINTEXT', 'CRYPT' => 'CRYPT', 'MD5' => 'MD5', 'SHA' => 'SHA', 'AD' => 'Active Directory')
        ),
        'operation' => array(
            'type'          => VAR_TYPE_STRING,
            'form_type'     => FORM_TYPE_HIDDEN
        )
    );
}

/**
 *  System_Createアクションの実装
 *
 *  @author     {$author}
 *  @access     public
 *  @package    Secioss
 */
class Secioss_Action_SystemCreate extends Secioss_ActionClass
{
    /**
     *  System_Createアクションの前処理
     *
     *  @access public
     *  @return string      遷移名(正常終了ならnull, 処理終了ならfalse)
     */
    function prepare()
    {
        $this->af->synctype_select = array('slave' => _et('スレーブ'), 'master' => _et('マスタ'));
        $this->af->ldaptype_select = array('LDAP' => _et('LDAPサーバ'), 'AD' => 'Active Directory');

        if ($this->af->get('operation') != 'create') {
            return 'System_Create';
        }

        if ($this->af->validate() > 0) {
            $this->ae->add(null, $this->getInvalidValMsg($this->getErrorFormName()));

            return 'System_Create';
        }

        return null;
    }

    /**
     *  System_Createアクションの実装
     *
     *  @access public
     *  @return string  遷移名
     */
    function perform()
    {
        $confmgr =& $this->backend->getManager('Config');
        $logger = & $this->backend->getLogger();
        $login_user = $this->session->get('user');

        $id = $this->af->get('newid');
        $synctype = $this->af->get('newsynctype');
        $ldaptype = $this->af->get('newldaptype');
        $ldapuri = $this->af->get('newldapuri');
        $basedn = $this->af->get('newbasedn');
        $binddn = $this->af->get('newbinddn');
        $bindpw = $this->af->get('newbindpw');
        $op = $this->af->get('operation');
        $conf = $this->config->get('secioss');

        if (preg_match('/^Master$/i', $id)) {
            $this->ae->add(null, 'IDに'.S_INVALID_INPUT_VALUE_MSG);

            return 'System_Create';
        }

        $values = $confmgr->getXmlFile(LISMCONF, array('master'));
        if (Ethna::isError($values)) {
            $logger->log(LOG_ERR, "$login_user failed to get the master: ".$values->getMessage());
            $this->ae->add(null, S_INTERNAL_ERR_MSG);

            return 'System_Create';
        } else if ($synctype == 'master' && $values[0]) {
            $this->ae->add(null, 'マスタサーバは'.O_ALREADY_EXISTS_MSG);

            return 'System_Create';
        }

        if ($ldaptype == 'AD') {
            $this->af->set('pwhash', 'AD');
        }
        $hash = $this->af->get('newpwhash');

        $params['storage'] = $ldaptype;
        $params['uri'] = $ldapuri;
        $params['basedn'] = $basedn;
        $params['binddn'] = $binddn;
        if($bindpw) {
            $params['bindpw'] = $bindpw;
        }
        $params['hash'] = $hash;
        if ($synctype == 'master') {
            $params['master'] = $id;
        }

        $r = $confmgr->setXmlFile(LISMCONF, $params, $id);
        if(Ethna::isError($r)) {
            $logger->log(LOG_ERR,$r->getMessage());
            $this->ae->add(null, S_INTERNAL_ERR_MSG);

            return 'System_Create';
        }
        if (system(LISMRELOAD) == "0") {
            $logger->log(LOG_ERR,$r->getMessage());
            $this->ae->add(null, C_RELOAD_ERR_MSG);

            return 'System_Create';
        }

        $this->af->set('dn', $id);
        $this->af->set('synctype', $synctype);
        $this->af->set('ldaptype', $ldaptype);
        $this->af->set('ldapuri', $ldapuri);
        $this->af->set('basedn', $basedn);
        $this->af->set('binddn', $binddn);
        $this->af->set('pwhash', $hash);

        $this->af->setApp('message', C_UPDATE_SUCCESS_MSG);
        $logger->log(LOG_INFO, "Succeeded to add LDAP config");

        return 'System_Update';
    }
}
?>
