<?php
/**
 *  System/Delete.php
 *
 *  @author     {$author}
 *  @package    Secioss
 *  @version    $Id: skel.action.php 387 2006-11-06 14:31:24Z cocoitiban $
 */

/**
 *  System_Deleteフォームの実装
 *
 *  @author     {$author}
 *  @access     public
 *  @package    Secioss
 */
class Secioss_Form_SystemDelete extends Secioss_ActionForm
{
    /** @var    bool    バリデータにプラグインを使うフラグ */
    var $use_validator_plugin = true;

    /**
     *  @access private
     *  @var    array   フォーム値定義
     */
    var $form = array(
        'dn' => array(
            'type'          => VAR_TYPE_STRING,
            'form_type'     => FORM_TYPE_HIDDEN,
            'name'          => 'SP ID'
        ),
        'system_list' => array(
            'type'          => array(VAR_TYPE_STRING),
            'form_type'     => FORM_TYPE_CHECKBOX
        ),
        'ldaptype' => array(
            'type'          => VAR_TYPE_STRING,
            'form_type'     => FORM_TYPE_HIDDEN,
            'name'          => 'LDAPサーバの種類'
        ),
        'ldapuri' => array(
            'type'          => VAR_TYPE_STRING,
            'form_type'     => FORM_TYPE_TEXT,
            'name'          => 'LDAPサーバのURI',
            'regexp'        => '/^ldaps?:\/\/.+/'
        ),
        'basedn' => array(
            'type'          => VAR_TYPE_STRING,
            'form_type'     => FORM_TYPE_TEXT,
            'name'          => 'LDAPサーバのベースDN',
        ),
        'binddn' => array(
            'type'          => VAR_TYPE_STRING,
            'form_type'     => FORM_TYPE_TEXT,
            'name'          => 'LDAPサーバのユーザ名',
        ),
        'bindpw' => array(
            'type'          => VAR_TYPE_STRING,
            'form_type'     => FORM_TYPE_PASSWORD,
            'name'          => 'LDAPサーバのパスワード',
        ),
        'pwhash' => array(
            'type'          => VAR_TYPE_STRING,
            'form_type'     => FORM_TYPE_SELECT,
            'name'          => 'パスワードハッシュ形式',
            'option'        => array('PLAINTEXT' => 'PLAINTEXT', 'CRYPT' => 'CRYPT', 'MD5' => 'MD5', 'SHA' => 'SHA', 'AD' => 'Active Directory')
        ),
        'operation' => array(
            'type'          => VAR_TYPE_STRING,
            'form_type'     => FORM_TYPE_HIDDEN,
            'required'      => true
        )
    );
}

/**
 *  System_Deleteアクションの実装
 *
 *  @author     {$author}
 *  @access     public
 *  @package    Secioss
 */
class Secioss_Action_SystemDelete extends Secioss_ActionClass
{
    /**
     *  System_Deleteアクションの前処理
     *
     *  @access public
     *  @return string      遷移名(正常終了ならnull, 処理終了ならfalse)
     */
    function prepare()
    {
        return null;
    }

    /**
     *  System_Deleteアクションの実装
     *
     *  @access public
     *  @return string  遷移名
     */
    function perform()
    {
        $confmgr =& $this->backend->getManager('Config');
        $logger =& $this->backend->getLogger();
        $login_user = $this->session->get('user');

        // input value
        $dn = $this->af->get('dn');
        $operation = $this->af->get('operation');
        $error = false;

        if ($dn && $dn != 'null') {
            $system_list = array($dn);
        } else {
            $system_list = $this->af->get('system_list');
        }

        for ($i = 0; $i < count($system_list); $i++) {
            if (file_exists(LISMCONF)) {
                $r = $confmgr->setXmlFile(LISMCONF, null, $system_list[$i]);
                if (Ethna::isError($r)) {
                    $logger->log(LOG_ERR, "Can't remove ".$system_list[$i]);
                    if (!$error) {
                        $this->ae->add(null, S_INTERNAL_ERR_MSG);
                        $error = true;
                    }
                    continue;
                }
            }
        }

        if (system(LISMRELOAD) == "0") {
            $logger->log(LOG_ERR,$r->getMessage());
            $error = true;
        }

        if (!$error) {
            $this->af->setApp('message', C_DELETE_SUCCESS_MSG);
        }

        if ($operation == 'read' || !$error) {
            return 'System_DeleteRead';
        } else {
            return 'System_Update';
        }
    }
}
?>
