<?php
/**
 *  User/Delete.php
 *
 *  @author     {$author}
 *  @package    Secioss
 *  @version    $Id: skel.action.php,v 1.10 2006/11/06 14:31:24 cocoitiban Exp $
 */

/**
 *  user_deleteフォームの実装
 *
 *  @author     {$author}
 *  @access     public
 *  @package    Secioss
 */
class Secioss_Form_UserDelete extends Secioss_ActionForm
{
    /** @var    bool    バリデータにプラグインを使うフラグ */
    var $use_validator_plugin = true;

    /**
     *  @access private
     *  @var    array   フォーム値定義
     */
    var $form = array(
        'dn' => array(
            'type'          => VAR_TYPE_STRING,
            'form_type'     => FORM_TYPE_HIDDEN
        ),
        'user_list' => array(
            'type'          => array(VAR_TYPE_STRING),
            'form_type'     => FORM_TYPE_CHECKBOX
        ),
        'id' => array(
            'type'          => VAR_TYPE_STRING,
            'form_type'     => FORM_TYPE_HIDDEN,
            'name'          => 'ユーザID',
        ),
        'loginid' => array(
            'type'          => VAR_TYPE_STRING,
            'form_type'     => FORM_TYPE_TEXT,
            'name'          => 'ログインID'
        ),
        'snkanji' => array(
            'type'          => VAR_TYPE_STRING,
            'form_type'     => FORM_TYPE_TEXT,
            'name'          => '姓',
            'required'        => true
        ),
        'gnkanji' => array(
            'type'          => VAR_TYPE_STRING,
            'form_type'     => FORM_TYPE_TEXT,
            'name'          => '名'
        ),
        'snkana' => array(
            'type'          => VAR_TYPE_STRING,
            'form_type'     => FORM_TYPE_TEXT,
            'name'          => '姓',
            'min'           => null,
            'max'           => null,
            'regexp'        => null
        ),
        'gnkana' => array(
            'type'          => VAR_TYPE_STRING,
            'form_type'     => FORM_TYPE_TEXT,
            'name'          => '名',
            'min'           => null,
            'max'           => null,
            'regexp'        => null
        ),
        'empnum' => array(
            'type'          => VAR_TYPE_STRING,
            'form_type'     => FORM_TYPE_HIDDEN,
            'name'          => '社員番号'
        ),
        'mail' => array(
            'type'          => VAR_TYPE_STRING,
            'form_type'     => FORM_TYPE_TEXT,
            'name'          => 'メールアドレス',
            'min'           => null,
            'max'           => null,
            'regexp'        => '/^[a-zA-Z0-9]+[a-zA-Z0-9\._-]*@[a-zA-Z0-9]+[a-zA-Z0-9\._-]+$/',
        ),
        'password' => array(
            'type'          => VAR_TYPE_STRING,
            'form_type'     => FORM_TYPE_PASSWORD,
            'name'          => 'パスワード',
            'min'           => 4,
            'max'           => 20
        ),
        'status' => array(
            'type'          => VAR_TYPE_STRING,
            'form_type'     => FORM_TYPE_SELECT,
            'name'          => 'ユーザ状態',
            'option'        => 'status_select'
        ),
        'unlock' => array(
            'type'          => array(VAR_TYPE_BOOLEAN),
            'form_type'     => FORM_TYPE_CHECKBOX,
            'name'          => 'ロックアウト解除',
            'option'        => 'unlock_check'
        ),
        'lockout' => array(
            'type'          => VAR_TYPE_BOOLEAN,
            'form_type'     => FORM_TYPE_HIDDEN
        ),
        'pwloduration' => array(
            'type'          => VAR_TYPE_INT,
            'form_type'     => FORM_TYPE_TEXT,
            'name'          => 'ロックアウトの解除時間（分）',
            'min'           => 0,
            'regexp'        => '/^[0-9]+$/'
        ),
        'sync' => array(
            'type'          => array(VAR_TYPE_STRING),
            'form_type'     => FORM_TYPE_CHECKBOX,
            'name'          => '更新対象システム',
            'option'        => 'sync_select'
        ),
        'user_name' => array(
            'type'          => VAR_TYPE_STRING,
            'form_type'     => FORM_TYPE_HIDDEN
        ),
        'operation' => array(
            'type'          => VAR_TYPE_STRING,
            'form_type'     => FORM_TYPE_HIDDEN
        )
    );
}

/**
 *  user_deleteアクションの実装
 *
 *  @author     {$author}
 *  @access     public
 *  @package    Secioss
 */
class Secioss_Action_UserDelete extends Secioss_ActionClass
{
    /**
     *  user_deleteアクションの前処理
     *
     *  @access public
     *  @return string      遷移名(正常終了ならnull, 処理終了ならfalse)
     */
    function prepare()
    {
        $this->af->status_select = array('active' => _et('有効'), 'inactive' => _et('無効'));
        $this->af->unlock_check = array(true => _et('ロックアウト解除'));

        return null;
    }

    /**
     *  user_deleteアクションの実装
     *
     *  @access public
     *  @return string  遷移名
     */
    function perform()
    {
        $auth =& $this->backend->getManager('Auth');
        $logger =& $this->backend->getLogger();
        $login_user = $this->session->get('user');

        // input value
        $dn = $this->af->get('dn');
        $operation = $this->af->get('operation');

        if ($dn && $dn != null) {
            $users = array($dn);
        } else {
            $users = $this->af->get('user_list');
        }

        for ($i = 0; $i < count($users); $i++) {
            // delete user data
            $r = $auth->removeObject('user', array('id'), array($users[$i]));
            if (Ethna::isError($r)) {
                $logger->log(LOG_ERR, "$login_user failed to delete the user($users[$i]): ".$r->getMessage());
                $this->ae->add(null, _et(O_DELETE_ERR_MSG));

                if ($operation == 'read') {
                    $this->af->set('dn', $users[$i]);
                    return 'user_delete';
                } else {
                    return 'user_update';
                }
            }

            $logger->log(LOG_INFO, "$login_user succeeded to delete the user($users[$i])");
        }

        $this->af->setApp('message', _et(O_DELETE_SUCCESS_MSG));

        if ($operation == 'read') {
            return 'user_deleteRead';
        } else {
            return 'user_delete';
        }
    }
}
?>
