<?php
/**
 *  Sync/Search.php
 *
 *  @author     {$author}
 *  @package    Secioss
 *  @version    $Id: skel.view.php,v 1.8 2006/11/06 14:31:24 cocoitiban Exp $
 */

/**
 *  sync_searchビューの実装
 *
 *  @author     {$author}
 *  @access     public
 *  @package    Secioss
 */
class Secioss_View_SyncSearch extends Secioss_ViewClass
{
    /**
     *  遷移前処理
     *
     *  @access public
     */
    function preforward()
    {
        $auth =& $this->backend->getManager('Auth');
        $logger = & $this->backend->getLogger();

        if ($this->session->get('role') == 'system_admin') {
            $list = $auth->getAttrList('area');
            if (Ethna::isError($list)) {
                $logger->log(LOG_ERR, "Failed to get the tenants: ".$list->getMessage());
                $this->ae->add(null, S_INTERNAL_ERR_MSG);

                return;
            }
            $this->af->tenant_select = $list;
        }

        $values = $auth->readCluster('cluster');
        if(Ethna::isError($values)) {
            $logger->log(LOG_ERR,$values->getMessage());
            $this->ae->add(null, S_INTERNAL_ERR_MSG);

            return;
        }
        $this->af->setApp('cluster_list', $values);

        $values = $auth->readCluster('master');
        if(Ethna::isError($values)) {
            $logger->log(LOG_ERR,$values->getMessage());
            $this->ae->add(null, S_INTERNAL_ERR_MSG);

            return;
        }
        $this->af->setApp('master_list', $values);
    }
}
?>
