//
function doAddItem(org_id, dst_id) {
    var org = document.getElementById(org_id);
    var dst = document.getElementById(dst_id);
    if (org == null || dst == null || !org.value) {
        return;
    }
    //
    var same = false;
    for (var j = 0; j < dst.length; j++) {
        var dst_item = dst.item(j);
        if (org.value == dst_item.value) {
            same = true;
        }
    }
    if (!same) {
        var opt = document.createElement("OPTION");
        opt.text = org.value;
        opt.value = org.value;
        dst.options.add(opt);
        org.value = '';
    }
}
//
function doMoveListItem(org_id, dst_id) {
    var org = document.getElementById(org_id);
    var dst = document.getElementById(dst_id);
    if (org == null || dst == null) {
        return;
    }
    //
    for (var i = 0; i < org.length; i++) {
        var org_item = org.item(i);
        if (org_item.selected == true) {
            var same = false;
            for (var j = 0; j < dst.length; j++) {
                var dst_item = dst.item(j);
                if (org_item.value == dst_item.value) {
                    same = true;
                }
            }
            if (!same) {
                var opt = document.createElement("OPTION");
                opt.text = org_item.text;
                opt.value = org_item.value;
                dst.options.add(opt);
            }
        }
    }
}
//
function doRemoveListItem(id) {
    //
    var list = document.getElementById(id);
    if (list == null) {
        return;
    }
    //
    for (var i = list.length -1; i > -1; i--) {
        var item = list.item(i);
        if (item.selected == true) {
            list.remove(i);
        }
    }
}
//
function doMoveItem(id, mode) {
    //
    var list = document.getElementById(id);
    if (list == null) {
        return;
    }
    //
    for (var i = 0; i < list.length; i++) {
        var item = list.item(i);
        if (item.selected == true) {
            break;
        }
    }

    if ((mode < 0 && i == 0) || (mode > 0 && i == list.length)) {
        return;
    }

    var tmpitem = list.removeChild(list.options[i]);
    list.insertBefore(tmpitem, list.options[i + mode]);
}

function doSelectItem(id) {
    //
    var list = document.getElementById(id);
    if (list == null) {
        return;
    }
    //
    for (var i = 0; i < list.length; i++) {
        list.item(i).selected = true;
    }
}
